/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.ansi.console;

import java.util.LinkedList;
import java.util.List;
import net.rubygrapefruit.ansi.NormalizingVisitor;
import net.rubygrapefruit.ansi.TextAttributes;
import net.rubygrapefruit.ansi.Visitor;
import net.rubygrapefruit.ansi.token.BackgroundColor;
import net.rubygrapefruit.ansi.token.BoldOff;
import net.rubygrapefruit.ansi.token.BoldOn;
import net.rubygrapefruit.ansi.token.CarriageReturn;
import net.rubygrapefruit.ansi.token.CursorBackward;
import net.rubygrapefruit.ansi.token.CursorDown;
import net.rubygrapefruit.ansi.token.CursorForward;
import net.rubygrapefruit.ansi.token.CursorUp;
import net.rubygrapefruit.ansi.token.EraseInLine;
import net.rubygrapefruit.ansi.token.EraseToBeginningOfLine;
import net.rubygrapefruit.ansi.token.EraseToEndOfLine;
import net.rubygrapefruit.ansi.token.ForegroundColor;
import net.rubygrapefruit.ansi.token.NewLine;
import net.rubygrapefruit.ansi.token.Text;
import net.rubygrapefruit.ansi.token.Token;

public class AnsiConsole
implements Visitor {
    private final LinkedList<RowImpl> rows = new LinkedList();
    private int col;
    private int row;
    private TextAttributes attributes = TextAttributes.NORMAL;

    public AnsiConsole() {
        this.rows.add(new RowImpl());
    }

    public String toString() {
        return "{console row: " + this.row + " col: " + this.col + " rows: " + this.rows + "}";
    }

    @Override
    public void visit(Token token) {
        if (token instanceof NewLine) {
            ++this.row;
            this.col = 0;
            if (this.row >= this.rows.size()) {
                this.rows.add(new RowImpl());
            }
        } else if (token instanceof CarriageReturn) {
            this.col = 0;
        } else if (token instanceof CursorUp) {
            this.row = Math.max(0, this.row - ((CursorUp)token).getCount());
        } else if (token instanceof CursorDown) {
            this.row += ((CursorDown)token).getCount();
            while (this.row >= this.rows.size()) {
                this.rows.add(new RowImpl());
            }
        } else if (token instanceof CursorBackward) {
            this.col = Math.max(0, this.col - ((CursorBackward)token).getCount());
        } else if (token instanceof CursorForward) {
            this.col += ((CursorForward)token).getCount();
        } else if (token instanceof EraseInLine) {
            this.rows.get(this.row).erase(this.col);
        } else if (token instanceof EraseToBeginningOfLine) {
            this.rows.get(this.row).eraseToStart(this.col);
        } else if (token instanceof EraseToEndOfLine) {
            this.rows.get(this.row).eraseToEnd(this.col);
        } else if (token instanceof BoldOn) {
            this.attributes = this.attributes.boldOn();
        } else if (token instanceof BoldOff) {
            this.attributes = this.attributes.boldOff();
        } else if (token instanceof ForegroundColor) {
            ForegroundColor color = (ForegroundColor)token;
            this.attributes = this.attributes.color(color.getColor());
        } else if (token instanceof BackgroundColor) {
            BackgroundColor color = (BackgroundColor)token;
            this.attributes = this.attributes.background(color.getColor());
        } else {
            this.col = this.rows.get(this.row).insertAt(this.col, token, this.attributes);
        }
    }

    public List<? extends Row> getRows() {
        return this.rows;
    }

    public <T extends Visitor> T contents(T visitor) {
        NormalizingVisitor normalizingVisitor = NormalizingVisitor.of(visitor);
        for (int i = 0; i < this.rows.size(); ++i) {
            RowImpl row = this.rows.get(i);
            if (i > 0) {
                normalizingVisitor.visit(NewLine.INSTANCE);
            }
            row.doVisit(normalizingVisitor);
        }
        normalizingVisitor.endStream();
        return visitor;
    }

    private static class RowImpl
    implements Row {
        private final Span first = new Span();

        private RowImpl() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.first.collectDetails(builder);
            return builder.toString();
        }

        @Override
        public <T extends Visitor> T visit(T visitor) {
            NormalizingVisitor normalizingVisitor = NormalizingVisitor.of(visitor);
            this.doVisit(normalizingVisitor);
            normalizingVisitor.endStream();
            return visitor;
        }

        void doVisit(Visitor visitor) {
            this.first.visit(visitor);
        }

        int insertAt(int col, Token token, TextAttributes attributes) {
            if (token instanceof Text) {
                Text text = (Text)token;
                this.first.insertAt(col, text.getText(), attributes);
                return col + text.getText().length();
            }
            return col;
        }

        void erase(int col) {
            this.first.erase(col);
        }

        void eraseToStart(int col) {
            this.first.eraseToStart(col + 1);
        }

        void eraseToEnd(int col) {
            this.first.eraseToEnd(col);
        }
    }

    private static class Span {
        private final StringBuilder chars;
        private TextAttributes attributes;
        private Span next;

        Span(String text, TextAttributes attributes) {
            this.attributes = attributes;
            this.chars = new StringBuilder(text);
        }

        Span() {
            this.attributes = TextAttributes.NORMAL;
            this.chars = new StringBuilder();
        }

        void collectDetails(StringBuilder builder) {
            builder.append("{");
            if (this.attributes.isBold()) {
                builder.append("bold ");
            }
            if (!this.attributes.getColor().isDefault()) {
                builder.append("color: ").append(this.attributes.getColor()).append(" ");
            }
            if (!this.attributes.getBackground().isDefault()) {
                builder.append("background: ").append(this.attributes.getBackground()).append(" ");
            }
            builder.append("'").append((CharSequence)this.chars).append("'}");
            if (this.next != null) {
                this.next.collectDetails(builder);
            }
        }

        void visit(Visitor visitor) {
            if (this.chars.length() > 0) {
                if (this.attributes.isBold()) {
                    visitor.visit(BoldOn.INSTANCE);
                } else {
                    visitor.visit(BoldOff.INSTANCE);
                }
                visitor.visit(ForegroundColor.of(this.attributes.getColor()));
                visitor.visit(BackgroundColor.of(this.attributes.getBackground()));
                visitor.visit(new Text(this.chars.toString()));
            }
            if (this.next != null) {
                this.next.visit(visitor);
            }
        }

        void insertAt(int col, String text, TextAttributes attributes) {
            if (col > this.chars.length()) {
                if (this.next != null) {
                    this.next.insertAt(col - this.chars.length(), text, attributes);
                } else if (this.attributes.equals(TextAttributes.NORMAL)) {
                    while (col > this.chars.length()) {
                        this.chars.append(' ');
                    }
                    if (attributes.equals(TextAttributes.NORMAL)) {
                        this.chars.append(text);
                    } else {
                        this.next = new Span(text, attributes);
                    }
                } else {
                    this.next = new Span();
                    this.next.insertAt(col - this.chars.length(), text, attributes);
                }
            } else if (col == this.chars.length()) {
                if (this.next != null) {
                    this.next.insertAt(0, text, attributes);
                } else if (attributes.equals(this.attributes)) {
                    this.chars.append(text);
                } else if (this.chars.length() == 0) {
                    this.attributes = attributes;
                    this.chars.append(text);
                } else {
                    this.next = new Span(text, attributes);
                }
            } else if (attributes.equals(this.attributes)) {
                int replace = Math.min(text.length(), this.chars.length() - col);
                if (replace == text.length()) {
                    this.chars.replace(col, col + text.length(), text);
                } else {
                    this.chars.setLength(col);
                    this.chars.append(text);
                    if (this.next != null) {
                        this.next = this.next.remove(text.length() - replace);
                    }
                }
            } else {
                int endPos = col + text.length();
                if (endPos < this.chars.length()) {
                    Span tail = new Span(this.chars.substring(endPos), this.attributes);
                    tail.next = this.next;
                    Span replaced = new Span(text, attributes);
                    replaced.next = tail;
                    this.chars.setLength(col);
                    this.next = replaced;
                } else {
                    int remove = endPos - this.chars.length();
                    if (col == 0) {
                        this.chars.setLength(0);
                        this.attributes = attributes;
                        this.chars.append(text);
                        if (this.next != null) {
                            this.next = this.next.remove(remove);
                        }
                    } else {
                        this.chars.setLength(col);
                        Span replaced = new Span(text, attributes);
                        if (this.next != null) {
                            this.next = this.next.remove(remove);
                        }
                        replaced.next = this.next;
                        this.next = replaced;
                    }
                }
            }
        }

        private Span remove(int count) {
            if (count == 0) {
                return this;
            }
            if (count == this.chars.length()) {
                return this.next;
            }
            if (count < this.chars.length()) {
                this.chars.replace(0, count, "");
                return this;
            }
            if (this.next != null) {
                return this.next.remove(count - this.chars.length());
            }
            return null;
        }

        void eraseToEnd(int pos) {
            if (pos == this.chars.length()) {
                this.next = null;
            } else if (pos < this.chars.length()) {
                this.chars.setLength(pos);
                this.next = null;
            } else if (this.next != null) {
                this.next.eraseToEnd(pos - this.chars.length());
            } else if (!this.attributes.equals(TextAttributes.NORMAL)) {
                this.next = new Span();
                this.next.eraseToEnd(pos - this.chars.length());
            } else {
                while (pos > this.chars.length()) {
                    this.chars.append(' ');
                }
            }
        }

        void erase(int col) {
            this.attributes = TextAttributes.NORMAL;
            this.chars.setLength(col);
            for (int i = 0; i < col; ++i) {
                this.chars.setCharAt(i, ' ');
            }
            this.next = null;
        }

        void eraseToStart(int pos) {
            if (pos <= this.chars.length()) {
                for (int i = 0; i < pos; ++i) {
                    this.chars.setCharAt(i, ' ');
                }
                if (!this.attributes.equals(TextAttributes.NORMAL)) {
                    if (pos == this.chars.length()) {
                        this.attributes = TextAttributes.NORMAL;
                    } else {
                        Span replaced = new Span(this.chars.substring(pos, this.chars.length()), this.attributes);
                        this.chars.setLength(pos);
                        this.attributes = TextAttributes.NORMAL;
                        replaced.next = this.next;
                        this.next = replaced;
                    }
                }
            } else {
                int remove = pos - this.chars.length();
                this.chars.setLength(pos);
                this.attributes = TextAttributes.NORMAL;
                for (int i = 0; i < pos; ++i) {
                    this.chars.setCharAt(i, ' ');
                }
                if (this.next != null) {
                    this.next = this.next.remove(remove);
                }
            }
        }
    }

    public static interface Row {
        public <T extends Visitor> T visit(T var1);
    }
}

