/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.runnerkit.AbstractGradleExecutor;
import dev.gradleplugins.runnerkit.GradleDistribution;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutionResult;
import dev.gradleplugins.runnerkit.GradleExecutionResultTestKitImpl;
import dev.gradleplugins.runnerkit.GradleRunner;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.distributions.DownloadableGradleDistribution;
import dev.gradleplugins.runnerkit.distributions.LocalGradleDistribution;
import dev.gradleplugins.runnerkit.distributions.VersionAwareGradleDistribution;
import dev.gradleplugins.runnerkit.providers.DaemonBaseDirectoryProvider;
import dev.gradleplugins.runnerkit.providers.DaemonIdleTimeoutProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionJvmSystemPropertyProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleUserHomeDirectoryProvider;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.testkit.runner.internal.GradleExecutionParameters;
import org.gradle.testkit.runner.internal.GradleProvider;
import org.gradle.testkit.runner.internal.ToolingApiGradleExecutor;

final class GradleExecutorGradleTestKitImpl
extends AbstractGradleExecutor {
    private final ToolingApiGradleExecutor delegate = new ToolingApiGradleExecutor();

    GradleExecutorGradleTestKitImpl() {
    }

    protected GradleExecutionResult doRun(GradleExecutionContext parameters) {
        if (!parameters.getDaemonIdleTimeout().equals(DaemonIdleTimeoutProvider.testKitIdleTimeout())) {
            throw new InvalidRunnerConfigurationException("Custom daemon idle timeout not supported for Gradle TestKit executor.");
        }
        if (!((File)parameters.getDaemonBaseDirectory().get()).equals(FileSystemUtils.file((File)((File)parameters.getGradleUserHomeDirectory().get()), (Object[])new Object[]{"test-kit-daemon"}))) {
            throw new InvalidRunnerConfigurationException("Custom daemon directory not supported for Gradle TestKit executor.");
        }
        if (((GradleExecutionContext.WelcomeMessage)parameters.getWelcomeMessageRendering().get()).equals((Object)GradleExecutionContext.WelcomeMessage.ENABLED)) {
            throw new InvalidRunnerConfigurationException("Rendering the welcome message is not supported for Gradle TestKit executor.");
        }
        return new GradleExecutionResultTestKitImpl(this.delegate.run(GradleExecutorGradleTestKitImpl.asTestKitParameters(parameters)));
    }

    private static GradleExecutionParameters asTestKitParameters(GradleExecutionContext parameters) {
        return new GradleExecutionParameters(GradleExecutorGradleTestKitImpl.gradleProvider((GradleExecutionProvider<GradleDistribution>)parameters.getDistribution()), (File)parameters.getGradleUserHomeDirectory().get(), (File)parameters.getProjectDirectory().orElseGet(() -> ((GradleExecutionProvider)parameters.getWorkingDirectory()).get()), GradleExecutorGradleTestKitImpl.buildArguments(parameters), GradleExecutorGradleTestKitImpl.jvmArguments(parameters), GradleExecutorGradleTestKitImpl.injectedClasspath(parameters), false, (OutputStream)parameters.getStandardOutput().get(), (OutputStream)parameters.getStandardError().get(), null, GradleExecutorGradleTestKitImpl.environmentVariables(parameters));
    }

    private static ClassPath injectedClasspath(GradleExecutionContext context) {
        return DefaultClassPath.of((Collection)((Collection)context.getInjectedClasspath().get()));
    }

    private static GradleProvider gradleProvider(GradleExecutionProvider<GradleDistribution> parameter) {
        return parameter.map(it -> {
            if (it instanceof VersionAwareGradleDistribution) {
                return GradleProvider.version((String)((VersionAwareGradleDistribution)it).getVersion());
            }
            if (it instanceof LocalGradleDistribution) {
                return GradleProvider.installation((File)((LocalGradleDistribution)it).getInstallationDirectory());
            }
            if (it instanceof DownloadableGradleDistribution) {
                return GradleProvider.uri((URI)((DownloadableGradleDistribution)it).getUri());
            }
            throw new InvalidRunnerConfigurationException("Unknown Gradle distribution.");
        }).orElseGet(GradleExecutorGradleTestKitImpl::findGradleInstallFromGradleRunner);
    }

    private static GradleProvider findGradleInstallFromGradleRunner() {
        GradleInstallation gradleInstallation = CurrentGradleInstallation.get();
        if (gradleInstallation == null) {
            String messagePrefix = "Could not find a Gradle installation to use based on the location of the GradleRunner class";
            try {
                File classpathForClass = ClasspathUtil.getClasspathForClass(GradleRunner.class);
                messagePrefix = messagePrefix + ": " + classpathForClass.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new InvalidRunnerConfigurationException(messagePrefix + ". Please specify a Gradle runtime to use via GradleRunner.withGradleVersion() or similar.");
        }
        return GradleProvider.installation((File)gradleInstallation.getGradleHome());
    }

    private static List<String> buildArguments(GradleExecutionContext parameters) {
        return parameters.getExecutionParameters().stream().filter(it -> it instanceof GradleExecutionCommandLineProvider && !(it instanceof GradleExecutionJvmSystemPropertyProvider) && !(it instanceof GradleUserHomeDirectoryProvider)).flatMap(GradleExecutorGradleTestKitImpl::asArguments).collect(Collectors.toList());
    }

    private static List<String> jvmArguments(GradleExecutionContext parameters) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(parameters.getExecutionParameters().stream().filter(it -> it instanceof GradleExecutionJvmSystemPropertyProvider && !(it instanceof DaemonBaseDirectoryProvider) && !(it instanceof DaemonIdleTimeoutProvider)).flatMap(GradleExecutorGradleTestKitImpl::asArguments).collect(Collectors.toList()));
        result.addAll(GradleExecutorGradleTestKitImpl.getImplicitBuildJvmArgs());
        return result;
    }

    private static Stream<String> asArguments(GradleExecutionProvider<?> parameter) {
        return ((GradleExecutionCommandLineProvider)parameter).getAsArguments().stream();
    }

    private static Map<String, String> environmentVariables(GradleExecutionContext parameters) {
        return parameters.getEnvironmentVariables().map(GradleExecutorGradleTestKitImpl::toStringValues).orElse(null);
    }

    private static Map<String, String> toStringValues(Map<String, ?> environmentVariables) {
        return environmentVariables.entrySet().stream().map(it -> new AbstractMap.SimpleImmutableEntry(it.getKey(), it.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

