/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.BuildResult;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutionResult;
import dev.gradleplugins.runnerkit.GradleExecutor;
import dev.gradleplugins.runnerkit.GradleRunner;
import dev.gradleplugins.runnerkit.GradleRunnerParameters;
import dev.gradleplugins.runnerkit.InvalidPluginMetadataException;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.UnexpectedBuildFailure;
import dev.gradleplugins.runnerkit.UnexpectedBuildSuccess;
import dev.gradleplugins.runnerkit.providers.BeforeExecuteActionsProvider;
import dev.gradleplugins.runnerkit.providers.BuildCacheProvider;
import dev.gradleplugins.runnerkit.providers.BuildScanProvider;
import dev.gradleplugins.runnerkit.providers.BuildScriptProvider;
import dev.gradleplugins.runnerkit.providers.CharacterEncodingProvider;
import dev.gradleplugins.runnerkit.providers.CommandLineArgumentsProvider;
import dev.gradleplugins.runnerkit.providers.ConsoleTypeProvider;
import dev.gradleplugins.runnerkit.providers.DeprecationChecksProvider;
import dev.gradleplugins.runnerkit.providers.EnvironmentVariablesProvider;
import dev.gradleplugins.runnerkit.providers.GradleDistributionProvider;
import dev.gradleplugins.runnerkit.providers.GradleUserHomeDirectoryProvider;
import dev.gradleplugins.runnerkit.providers.InjectedClasspathProvider;
import dev.gradleplugins.runnerkit.providers.LocaleProvider;
import dev.gradleplugins.runnerkit.providers.MissingSettingsFilePolicyProvider;
import dev.gradleplugins.runnerkit.providers.ProjectDirectoryProvider;
import dev.gradleplugins.runnerkit.providers.SettingsFileProvider;
import dev.gradleplugins.runnerkit.providers.StacktraceProvider;
import dev.gradleplugins.runnerkit.providers.StandardStreamProvider;
import dev.gradleplugins.runnerkit.providers.UserHomeDirectoryProvider;
import dev.gradleplugins.runnerkit.providers.WelcomeMessageProvider;
import dev.gradleplugins.runnerkit.providers.WorkingDirectoryProvider;
import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class GradleRunnerImpl
implements GradleRunner {
    private final GradleExecutor executor;
    private final GradleRunnerParameters parameters;

    public GradleRunnerImpl(GradleExecutor executor) {
        this(executor, new GradleRunnerParameters(executor.getClass()));
    }

    private GradleRunnerImpl(GradleExecutor executor, GradleRunnerParameters parameters) {
        this.executor = executor;
        this.parameters = parameters;
    }

    private GradleRunnerImpl newInstance(GradleRunnerParameters parameters) {
        return new GradleRunnerImpl(this.executor, parameters);
    }

    public GradleRunner withGradleVersion(String versionNumber) {
        return this.newInstance(this.parameters.withDistribution(GradleDistributionProvider.version(versionNumber)));
    }

    public GradleRunner withGradleInstallation(File installation) {
        return this.newInstance(this.parameters.withDistribution(GradleDistributionProvider.installation(installation)));
    }

    public GradleRunner withGradleDistribution(URI distribution) {
        return this.newInstance(this.parameters.withDistribution(GradleDistributionProvider.uri(distribution)));
    }

    public List<? extends File> getPluginClasspath() {
        return (List)this.parameters.getInjectedClasspath().get();
    }

    public GradleRunner withPluginClasspath() throws InvalidPluginMetadataException {
        return this.newInstance(this.parameters.withInjectedClasspath(InjectedClasspathProvider.fromPluginUnderTestMetadata()));
    }

    public GradleRunner withPluginClasspath(Iterable<? extends File> classpath) {
        return this.newInstance(this.parameters.withInjectedClasspath(InjectedClasspathProvider.of(StreamSupport.stream(classpath.spliterator(), false).collect(Collectors.toList()))));
    }

    public GradleRunner inDirectory(File workingDirectory) {
        return this.newInstance(this.parameters.withWorkingDirectory(WorkingDirectoryProvider.of(workingDirectory)));
    }

    public GradleRunner inDirectory(Path workingDirectory) {
        return this.newInstance(this.parameters.withWorkingDirectory(WorkingDirectoryProvider.of(workingDirectory.toFile())));
    }

    public GradleRunner inDirectory(Supplier<?> workingDirectorySupplier) {
        return this.newInstance(this.parameters.withWorkingDirectory(WorkingDirectoryProvider.of(() -> {
            Object workingDirectory = Objects.requireNonNull(workingDirectorySupplier.get());
            if (workingDirectory instanceof File) {
                return (File)workingDirectory;
            }
            if (workingDirectory instanceof Path) {
                return ((Path)workingDirectory).toFile();
            }
            throw new IllegalArgumentException(String.format("Supplied working directory cannot be converted to a File instance: %s", workingDirectory.getClass()));
        })));
    }

    public File getWorkingDirectory() {
        if (this.parameters.getWorkingDirectory().isPresent()) {
            return (File)this.parameters.getWorkingDirectory().get();
        }
        throw new InvalidRunnerConfigurationException("Please use GradleRunner#inDirectory(File) API to configure a working directory for this runner.");
    }

    public GradleRunner withStacktraceDisabled() {
        return this.newInstance(this.parameters.withStacktrace(StacktraceProvider.hide()));
    }

    public GradleRunner withBuildCacheEnabled() {
        return this.newInstance(this.parameters.withBuildCache(BuildCacheProvider.enabled()));
    }

    public GradleRunner withTasks(List<String> tasks) {
        return this.newInstance(this.parameters.withTasks(this.parameters.getTasks().plus(tasks)));
    }

    public GradleRunner withArguments(List<String> args) {
        return this.newInstance(this.parameters.withArguments(CommandLineArgumentsProvider.of(args)));
    }

    public GradleRunner withArgument(String arg) {
        return this.newInstance(this.parameters.withArguments(this.parameters.getArguments().plus(arg)));
    }

    public List<String> getAllArguments() {
        return this.parameters.getAllArguments();
    }

    public GradleRunner usingSettingsFile(File settingsFile) {
        return this.newInstance(this.parameters.withSettingsFile(SettingsFileProvider.of(settingsFile)));
    }

    public GradleRunner ignoresMissingSettingsFile() {
        return this.newInstance(this.parameters.withMissingSettingsFilePolicy(MissingSettingsFilePolicyProvider.ignoresWhenMissing()));
    }

    public GradleRunner usingBuildScript(File buildScript) {
        return this.newInstance(this.parameters.withBuildScript(BuildScriptProvider.of(buildScript)));
    }

    public GradleRunner usingInitScript(File initScript) {
        return this.newInstance(this.parameters.withInitScripts(this.parameters.getInitScripts().plus(initScript)));
    }

    public GradleRunner usingProjectDirectory(File projectDirectory) {
        return this.newInstance(this.parameters.withProjectDirectory(ProjectDirectoryProvider.of(projectDirectory)));
    }

    public GradleRunner withoutDeprecationChecks() {
        return this.newInstance(this.parameters.withDeprecationChecks(DeprecationChecksProvider.ignores()));
    }

    public GradleRunner withDefaultCharacterEncoding(Charset defaultCharacterEncoding) {
        return this.newInstance(this.parameters.withDefaultCharacterEncoding(CharacterEncodingProvider.of(defaultCharacterEncoding)));
    }

    public GradleRunner withDefaultLocale(Locale defaultLocale) {
        return this.newInstance(this.parameters.withDefaultLocale(LocaleProvider.of(defaultLocale)));
    }

    public GradleRunner withWelcomeMessageEnabled() {
        return this.newInstance(this.parameters.withWelcomeMessageRendering(WelcomeMessageProvider.enabled()));
    }

    public GradleRunner publishBuildScans() {
        return this.newInstance(this.parameters.withBuildScan(BuildScanProvider.enabled()));
    }

    public GradleRunner withUserHomeDirectory(File userHomeDirectory) {
        return this.newInstance(this.parameters.withUserHomeDirectory(UserHomeDirectoryProvider.of(userHomeDirectory)));
    }

    public GradleRunner withGradleUserHomeDirectory(File gradleUserHomeDirectory) {
        return this.newInstance(this.parameters.withGradleUserHomeDirectory(GradleUserHomeDirectoryProvider.of(gradleUserHomeDirectory)));
    }

    public GradleRunner requireOwnGradleUserHomeDirectory() {
        return this.newInstance(this.parameters.withGradleUserHomeDirectory(GradleUserHomeDirectoryProvider.isolatedGradleUserHomeDirectory()));
    }

    public GradleRunner withEnvironmentVariables(Map<String, ?> environment) {
        return this.newInstance(this.parameters.withEnvironmentVariables(EnvironmentVariablesProvider.of(environment)));
    }

    public GradleRunner withEnvironmentVariable(String key, String value) {
        return this.newInstance(this.parameters.withEnvironmentVariables(this.parameters.getEnvironmentVariables().plus(Collections.singletonMap(key, value))));
    }

    public GradleRunner withEnvironmentVars(Map<String, ?> environmentVariables) {
        return this.newInstance(this.parameters.withEnvironmentVariables(this.parameters.getEnvironmentVariables().plus(environmentVariables)));
    }

    public GradleRunner withRichConsoleEnabled() {
        return this.newInstance(this.parameters.withConsoleType(ConsoleTypeProvider.richConsole()));
    }

    public GradleRunner configure(UnaryOperator<GradleRunner> action) {
        return (GradleRunner)Objects.requireNonNull(action.apply(this), "Please return a non-null GradleRunner from the configuration action when using GradleRunner#configure(action).");
    }

    public GradleRunner forwardStandardOutput(Writer writer) {
        return this.newInstance(this.parameters.withStandardOutput(StandardStreamProvider.of(writer)));
    }

    public GradleRunner forwardStandardError(Writer writer) {
        return this.newInstance(this.parameters.withStandardError(StandardStreamProvider.of(writer)));
    }

    public GradleRunner forwardOutput() {
        return this.newInstance(this.parameters.withStandardOutput(StandardStreamProvider.forwardToStandardOutput()).withStandardError(StandardStreamProvider.forwardToStandardOutput()));
    }

    public GradleRunner afterExecute(Consumer<GradleExecutionContext> action) {
        return this.newInstance(this.parameters.withAfterExecute(this.parameters.getAfterExecute().plus(action)));
    }

    private void fireAfterExecute() {
        ((List)this.parameters.getAfterExecute().get()).forEach(it -> it.accept(this.parameters));
    }

    public GradleRunner beforeExecute(UnaryOperator<GradleRunner> action) {
        return this.newInstance(this.parameters.withBeforeExecute(this.parameters.getBeforeExecute().plus(action)));
    }

    private GradleRunner fireBeforeExecute() {
        GradleRunnerImpl executer = this.newInstance(this.parameters.withBeforeExecute(BeforeExecuteActionsProvider.empty()));
        for (UnaryOperator it : (List)this.parameters.getBeforeExecute().get()) {
            executer = (GradleRunner)it.apply(executer);
        }
        return executer;
    }

    public BuildResult build() {
        if (((List)this.parameters.getBeforeExecute().get()).isEmpty()) {
            GradleExecutionResult gradleExecutionResult = this.executor.run((GradleExecutionContext)this.parameters.calculateValues());
            BuildResult result = BuildResult.from((String)gradleExecutionResult.getOutput());
            if (!gradleExecutionResult.isSuccessful()) {
                throw new UnexpectedBuildFailure(this.createDiagnosticsMessage("Unexpected build execution failure", gradleExecutionResult), result);
            }
            this.fireAfterExecute();
            return result;
        }
        return this.fireBeforeExecute().build();
    }

    public BuildResult buildAndFail() {
        if (((List)this.parameters.getBeforeExecute().get()).isEmpty()) {
            GradleExecutionResult gradleExecutionResult = this.executor.run((GradleExecutionContext)this.parameters.calculateValues());
            BuildResult result = BuildResult.from((String)gradleExecutionResult.getOutput());
            if (gradleExecutionResult.isSuccessful()) {
                throw new UnexpectedBuildSuccess(this.createDiagnosticsMessage("Unexpected build execution success", gradleExecutionResult), result);
            }
            this.fireAfterExecute();
            return result;
        }
        return this.fireBeforeExecute().buildAndFail();
    }

    String createDiagnosticsMessage(String trailingMessage, GradleExecutionResult gradleExecutionResult) {
        String lineBreak = System.lineSeparator();
        StringBuilder message = new StringBuilder();
        message.append(trailingMessage);
        message.append(" in ");
        message.append(this.parameters.getProjectDirectory().orElseGet(() -> GradleRunnerImpl.lambda$createDiagnosticsMessage$2(this.parameters.getWorkingDirectory())).getAbsolutePath());
        message.append(" with arguments ");
        message.append(this.parameters.getAllArguments());
        String output = gradleExecutionResult.getOutput();
        if (output != null && !output.isEmpty()) {
            message.append(lineBreak);
            message.append(lineBreak);
            message.append("Output:");
            message.append(lineBreak);
            message.append(output);
        }
        return message.toString();
    }

    private static /* synthetic */ File lambda$createDiagnosticsMessage$2(WorkingDirectoryProvider rec$) {
        return (File)rec$.get();
    }
}

