/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

import dev.nokee.utils.SpecUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public final class ActionUtils {
    public static <T> Action<T> doNothing() {
        return DoNothingAction.INSTANCE;
    }

    @SafeVarargs
    public static <T> Action<T> composite(org.gradle.api.Action<? super T> ... actions) {
        return ActionUtils.composite(Arrays.stream(actions).filter(ActionUtils::doesSomething).collect(Collectors.toList()));
    }

    public static <T> Action<T> composite(Iterable<? extends org.gradle.api.Action<? super T>> actions) {
        List filtered = StreamSupport.stream(actions.spliterator(), false).filter(ActionUtils::doesSomething).collect(Collectors.toList());
        return ActionUtils.composite(filtered);
    }

    private static <T> Action<T> composite(List<? extends org.gradle.api.Action<? super T>> actions) {
        switch (actions.size()) {
            case 0: {
                return ActionUtils.doNothing();
            }
            case 1: {
                return Action.of(actions.get(0));
            }
        }
        return new CompositeAction(actions);
    }

    public static boolean doesSomething(org.gradle.api.Action<?> action) {
        return action != DoNothingAction.INSTANCE;
    }

    public static <T> Action<T> onlyIf(Spec<? super T> spec, org.gradle.api.Action<? super T> action) {
        if (Specs.satisfyAll().equals(spec) || SpecUtils.satisfyAll().equals(spec)) {
            return Action.of(action);
        }
        if (Specs.satisfyNone().equals(spec) || SpecUtils.satisfyNone().equals(spec)) {
            return ActionUtils.doNothing();
        }
        return new SpecFilteringAction(spec, action);
    }

    @FunctionalInterface
    public static interface Action<T>
    extends org.gradle.api.Action<T> {
        public static <T> Action<T> of(org.gradle.api.Action<? super T> action) {
            if (action instanceof Action) {
                Action result = (Action)action;
                return result;
            }
            if (ActionUtils.doesSomething(action)) {
                return arg_0 -> action.execute(arg_0);
            }
            return ActionUtils.doNothing();
        }

        default public Action<T> andThen(Action<? super T> after) {
            return ActionUtils.composite(this, after);
        }
    }

    private static final class SpecFilteringAction<T>
    implements Action<T> {
        private final Spec<? super T> spec;
        private final org.gradle.api.Action<? super T> action;

        private SpecFilteringAction(Spec<? super T> spec, org.gradle.api.Action<? super T> action) {
            this.spec = Objects.requireNonNull(spec);
            this.action = Objects.requireNonNull(action);
        }

        public void execute(T t) {
            if (this.spec.isSatisfiedBy(t)) {
                this.action.execute(t);
            }
        }

        public String toString() {
            return "ActionUtils.onlyIf(" + this.spec + ", " + this.action + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecFilteringAction)) {
                return false;
            }
            SpecFilteringAction other = (SpecFilteringAction)o;
            Spec<T> this$spec = this.spec;
            Spec<? super T> other$spec = other.spec;
            if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
                return false;
            }
            org.gradle.api.Action<T> this$action = this.action;
            org.gradle.api.Action<? super T> other$action = other.action;
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Spec<T> $spec = this.spec;
            result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
            org.gradle.api.Action<T> $action = this.action;
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }
    }

    private static final class CompositeAction<T>
    implements Action<T> {
        private final Iterable<? extends org.gradle.api.Action<? super T>> actions;

        public CompositeAction(Iterable<? extends org.gradle.api.Action<? super T>> actions) {
            this.actions = actions;
        }

        public void execute(T t) {
            for (org.gradle.api.Action<? super T> action : this.actions) {
                action.execute(t);
            }
        }
    }

    private static enum DoNothingAction implements Action<Object>,
    Serializable
    {
        INSTANCE;


        public void execute(Object o) {
        }

        public String toString() {
            return "ActionUtils.doNothing()";
        }
    }
}

