/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.distributions.VersionAwareGradleDistribution;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.BeforeExecute;
import dev.gradleplugins.runnerkit.providers.GradleExecutionJvmSystemPropertyProvider;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WelcomeMessageProvider
extends AbstractGradleExecutionProvider<GradleExecutionContext.WelcomeMessage>
implements GradleExecutionJvmSystemPropertyProvider,
BeforeExecute {
    static final String WELCOME_MESSAGE_ENABLED_SYSTEM_PROPERTY = "org.gradle.internal.launcher.welcomeMessageEnabled";
    private static final String WELCOME_MESSAGE_ENABLED_FLAG = "-Dorg.gradle.internal.launcher.welcomeMessageEnabled=true";
    private static final String WELCOME_MESSAGE_DISABLED_FLAG = "-Dorg.gradle.internal.launcher.welcomeMessageEnabled=false";

    public static WelcomeMessageProvider enabled() {
        return WelcomeMessageProvider.fixed(WelcomeMessageProvider.class, GradleExecutionContext.WelcomeMessage.ENABLED);
    }

    public static WelcomeMessageProvider disabled() {
        return WelcomeMessageProvider.fixed(WelcomeMessageProvider.class, GradleExecutionContext.WelcomeMessage.DISABLED);
    }

    @Override
    public Map<String, String> getAsJvmSystemProperties() {
        if (((GradleExecutionContext.WelcomeMessage)this.get()).equals((Object)GradleExecutionContext.WelcomeMessage.ENABLED)) {
            return Collections.singletonMap(WELCOME_MESSAGE_ENABLED_SYSTEM_PROPERTY, Boolean.TRUE.toString());
        }
        return Collections.singletonMap(WELCOME_MESSAGE_ENABLED_SYSTEM_PROPERTY, Boolean.FALSE.toString());
    }

    @Override
    public void accept(GradleExecutionContext parameters) {
        if (parameters.getDistribution().get() instanceof VersionAwareGradleDistribution) {
            if (((GradleExecutionContext.WelcomeMessage)this.get()).equals((Object)GradleExecutionContext.WelcomeMessage.ENABLED)) {
                File welcomeMessageFile = FileSystemUtils.file((File)((File)parameters.getGradleUserHomeDirectory().get()), (Object[])new Object[]{"notifications/" + ((VersionAwareGradleDistribution)parameters.getDistribution().get()).getVersion() + "/release-features.rendered"});
                welcomeMessageFile.delete();
            } else {
                File welcomeMessageFile = FileSystemUtils.file((File)((File)parameters.getGradleUserHomeDirectory().get()), (Object[])new Object[]{"notifications/" + ((VersionAwareGradleDistribution)parameters.getDistribution().get()).getVersion() + "/release-features.rendered"});
                FileSystemUtils.touch((File)welcomeMessageFile);
            }
        }
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((GradleExecutionContext.WelcomeMessage)this.get()).equals((Object)GradleExecutionContext.WelcomeMessage.ENABLED)) {
            if (((List)context.getArguments().get()).contains(WELCOME_MESSAGE_ENABLED_FLAG)) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag enabling welcome message as the it was already enabled via GradleRunner#withWelcomeMessageEnabled().");
            }
            if (((List)context.getArguments().get()).contains(WELCOME_MESSAGE_DISABLED_FLAG)) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag disabling welcome message and any call to GradleRunner#withWelcomeMessageEnabled() for this runner as it is disabled by default for all toolbox runner.");
            }
        } else if (((GradleExecutionContext.WelcomeMessage)this.get()).equals((Object)GradleExecutionContext.WelcomeMessage.DISABLED)) {
            if (((List)context.getArguments().get()).contains(WELCOME_MESSAGE_ENABLED_FLAG)) {
                throw new InvalidRunnerConfigurationException("Please use GradleRunner#withWelcomeMessageEnabled() instead of using flag in command line arguments.");
            }
            if (((List)context.getArguments().get()).contains(WELCOME_MESSAGE_DISABLED_FLAG)) {
                throw new InvalidRunnerConfigurationException("Please remove command line flag disabling welcome message as the it is disabled by default for all toolbox runner.");
            }
        }
    }
}

