/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils.internal;

import com.google.common.base.Preconditions;
import dev.nokee.utils.DeferredUtils;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.Task;

public final class AssertingTaskAction
implements Action<Task> {
    private final Supplier<Boolean> expression;
    private final Object errorMessage;

    public void execute(Task task) {
        Boolean expression = (Boolean)Preconditions.checkNotNull((Object)this.expression.get());
        if (!expression.booleanValue()) {
            throw new IllegalArgumentException(String.valueOf(DeferredUtils.unpack(this.errorMessage)));
        }
    }

    public AssertingTaskAction(Supplier<Boolean> expression, Object errorMessage) {
        this.expression = expression;
        this.errorMessage = errorMessage;
    }

    public Supplier<Boolean> getExpression() {
        return this.expression;
    }

    public Object getErrorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertingTaskAction)) {
            return false;
        }
        AssertingTaskAction other = (AssertingTaskAction)o;
        Supplier<Boolean> this$expression = this.getExpression();
        Supplier<Boolean> other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Object this$errorMessage = this.getErrorMessage();
        Object other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<Boolean> $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Object $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "AssertingTaskAction(expression=" + this.getExpression() + ", errorMessage=" + this.getErrorMessage() + ")";
    }
}

