/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.logging;

import dev.gradleplugins.runnerkit.ActionableTaskCount;
import dev.gradleplugins.runnerkit.BuildOutcome;
import dev.gradleplugins.runnerkit.BuildTask;
import dev.gradleplugins.runnerkit.BuildTaskBuilder;
import dev.gradleplugins.runnerkit.TaskOutcome;
import dev.gradleplugins.runnerkit.TaskPath;
import dev.gradleplugins.runnerkit.logging.BuildLogVisitor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

public final class OutputScrappingBuildLogVisitor
implements BuildLogVisitor {
    private final Map<TaskPath, BuildTaskBuilder> discoveredTasks = new LinkedHashMap<TaskPath, BuildTaskBuilder>();
    private ActionableTaskCount actionableTaskCount = null;
    private BuildOutcome buildOutcome = null;

    public Optional<ActionableTaskCount> getActionableTaskCount() {
        return Optional.ofNullable(this.actionableTaskCount);
    }

    public BuildOutcome getBuildOutcome() {
        return this.buildOutcome;
    }

    public Map<TaskPath, BuildTask> getDiscoveredTasks() {
        return Collections.unmodifiableMap(this.discoveredTasks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((BuildTaskBuilder)it.getValue()).build(), OutputScrappingBuildLogVisitor.throwingMerger(), LinkedHashMap::new)));
    }

    @Override
    public void visitTaskHeader(TaskPath taskPath) {
        this.discoveredTasks.computeIfAbsent(taskPath, this::newTaskBuilder);
    }

    private BuildTaskBuilder newTaskBuilder(TaskPath taskPath) {
        return BuildTaskBuilder.newBuilder().withPath(taskPath);
    }

    @Override
    public void visitTaskHeader(TaskPath taskPath, TaskOutcome taskOutcome) {
        this.discoveredTasks.compute(taskPath, OutputScrappingBuildLogVisitor.updateOutcome(taskOutcome));
    }

    private static BiFunction<TaskPath, BuildTaskBuilder, BuildTaskBuilder> updateOutcome(TaskOutcome taskOutcome) {
        return (taskPath, buildTask) -> {
            if (buildTask == null) {
                return BuildTaskBuilder.newBuilder().withPath((TaskPath)taskPath).withOutcome(taskOutcome);
            }
            return buildTask.withOutcome(taskOutcome);
        };
    }

    @Override
    public void visitTaskOutput(TaskPath taskPath, String line) {
        this.discoveredTasks.compute(taskPath, OutputScrappingBuildLogVisitor.appendContent(line));
    }

    @Override
    public void visitBuildResult(BuildOutcome buildOutcome) {
        this.buildOutcome = buildOutcome;
    }

    @Override
    public void visitBuildFailure() {
    }

    @Override
    public void visitActionableTasks(ActionableTaskCount actionableTaskCount) {
        this.actionableTaskCount = actionableTaskCount;
    }

    @Override
    public void visitContentLine(String line) {
    }

    private static BiFunction<TaskPath, BuildTaskBuilder, BuildTaskBuilder> appendContent(String line) {
        return (taskPath, buildTask) -> {
            assert (buildTask != null);
            return buildTask.appendToOutput(line);
        };
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

