/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.utils;

public final class RunnableUtils {
    private RunnableUtils() {
    }

    public static Runnable onlyOnce(Runnable delegate) {
        return new OnlyOnceRunnable(delegate);
    }

    private static final class OnlyOnceRunnable
    implements Runnable {
        private final Runnable delegate;
        private boolean ranOnce = false;

        private OnlyOnceRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            if (!this.ranOnce) {
                this.delegate.run();
                this.ranOnce = true;
            }
        }

        public String toString() {
            return "RunnableUtils.onlyOnce(" + this.delegate + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OnlyOnceRunnable)) {
                return false;
            }
            OnlyOnceRunnable other = (OnlyOnceRunnable)o;
            Runnable this$delegate = this.delegate;
            Runnable other$delegate = other.delegate;
            return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Runnable $delegate = this.delegate;
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            return result;
        }
    }
}

