/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SettingsFileProvider
extends AbstractGradleExecutionProvider<File>
implements GradleExecutionCommandLineProvider {
    public static SettingsFileProvider unset() {
        return SettingsFileProvider.noValue(SettingsFileProvider.class);
    }

    public static SettingsFileProvider of(File settingsFile) {
        return SettingsFileProvider.fixed(SettingsFileProvider.class, settingsFile);
    }

    @Override
    public List<String> getAsArguments() {
        return this.map(SettingsFileProvider::asArguments).orElseGet(Collections::emptyList);
    }

    private static List<String> asArguments(File settingsFile) {
        return Arrays.asList("--settings-file", settingsFile.getAbsolutePath());
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((List)context.getArguments().get()).stream().anyMatch(it -> it.startsWith("--settings-file") || it.equals("-c"))) {
            throw new InvalidRunnerConfigurationException("Please use GradleRunner#usingSettingsFile(File) instead of using the command line flags.");
        }
    }
}

