/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

final class CommandLineToolInvocationEnvironmentVariablesUtils {
    private CommandLineToolInvocationEnvironmentVariablesUtils() {
    }

    static List<String> asList(Map<String, ?> environmentVariables) {
        return environmentVariables.entrySet().stream().map(CommandLineToolInvocationEnvironmentVariablesUtils::toListEntry).collect(Collectors.toList());
    }

    private static String toListEntry(Map.Entry<String, ?> entry) {
        return entry.getKey() + "=" + entry.getValue().toString();
    }

    static Map<String, String> asMap(List<?> environmentVariables) {
        return (Map)environmentVariables.stream().map(CommandLineToolInvocationEnvironmentVariablesUtils::toEntry).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map.Entry<String, String> toEntry(Object o) {
        String[] tokens = StringUtils.split((String)o.toString(), (String)"=", (int)2);
        if (tokens.length == 1) {
            return new AbstractMap.SimpleEntry<String, String>(tokens[0], "");
        }
        return new AbstractMap.SimpleEntry<String, String>(tokens[0], tokens[1]);
    }

    static Map<String, String> toStringOnEachEntry(Map<?, ?> environmentVariables) {
        return (Map)environmentVariables.entrySet().stream().map(CommandLineToolInvocationEnvironmentVariablesUtils::toStringEntry).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map.Entry<String, String> toStringEntry(Map.Entry<?, ?> entry) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(entry.getKey().toString(), entry.getValue().toString());
    }

    static Map<String, ?> merge(Map<String, ?> left, Map<String, ?> right) {
        HashMap result = new HashMap();
        result.putAll(left);
        result.putAll(right);
        return result;
    }

    static Map<String, ?> load(File file) {
        Properties result = new Properties();
        try (FileInputStream inStream = new FileInputStream(file);){
            result.load(inStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return CommandLineToolInvocationEnvironmentVariablesUtils.asMap(result);
    }

    static Map<String, String> asMap(Properties properties) {
        return CommandLineToolInvocationEnvironmentVariablesUtils.toStringOnEachEntry(properties);
    }
}

