/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DeprecationChecksProvider
extends AbstractGradleExecutionProvider<GradleExecutionContext.DeprecationChecks>
implements GradleExecutionCommandLineProvider {
    public static DeprecationChecksProvider fails() {
        return DeprecationChecksProvider.fixed(DeprecationChecksProvider.class, GradleExecutionContext.DeprecationChecks.FAILS);
    }

    public static DeprecationChecksProvider ignores() {
        return DeprecationChecksProvider.noValue(DeprecationChecksProvider.class);
    }

    @Override
    public List<String> getAsArguments() {
        if (this.isPresent() && ((GradleExecutionContext.DeprecationChecks)this.get()).equals((Object)GradleExecutionContext.DeprecationChecks.FAILS)) {
            return Arrays.asList("--warning-mode", "fail");
        }
        return Collections.emptyList();
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((List)context.getArguments().get()).stream().anyMatch(it -> it.startsWith("--warning-mode"))) {
            if (((List)context.getArguments().get()).stream().anyMatch(it -> it.endsWith("all") || it.endsWith("none"))) {
                throw new InvalidRunnerConfigurationException("Please open an issue on gradle-plugins/toolbox GitHub repository to support your use case.");
            }
            if (((List)context.getArguments().get()).stream().anyMatch(it -> it.endsWith("fails"))) {
                if (this.isPresent()) {
                    throw new InvalidRunnerConfigurationException("Please remove command line flag for failing warning mode as it is the default for all toolbox runner.");
                }
                throw new InvalidRunnerConfigurationException("Please remove command line flag for failing warning mode and any calls to GradleRunner#withoutDeprecationChecks() for this runner as it is the default for all toolbox runner.");
            }
            if (((List)context.getArguments().get()).stream().anyMatch(it -> it.endsWith("summary"))) {
                if (this.isPresent()) {
                    throw new InvalidRunnerConfigurationException("Please use GradleRunner#withoutDeprecationChecks() instead of using the command line flags.");
                }
                throw new InvalidRunnerConfigurationException("Please remove command line flag for summary warning mode as GradleRunner#withoutDeprecationChecks() already configure summary warning mode.");
            }
        }
    }
}

