/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolExecutionHandle;
import dev.nokee.core.exec.CommandLineToolExecutionResult;
import dev.nokee.core.exec.CommandLineToolInvocation;
import dev.nokee.core.exec.ProcessBuilderEngine;

public class CachingProcessBuilderEngine
implements CommandLineToolExecutionEngine<Handle> {
    private final CommandLineToolExecutionEngine<ProcessBuilderEngine.Handle> delegate;
    private final LoadingCache<CommandLineToolInvocation, CommandLineToolExecutionResult> cache = CacheBuilder.newBuilder().concurrencyLevel(4).build(new CacheLoader<CommandLineToolInvocation, CommandLineToolExecutionResult>(){

        @Override
        public CommandLineToolExecutionResult load(CommandLineToolInvocation key) throws Exception {
            return ((ProcessBuilderEngine.Handle)CachingProcessBuilderEngine.this.delegate.submit(key)).waitFor().assertNormalExitValue();
        }
    });

    public CachingProcessBuilderEngine(CommandLineToolExecutionEngine<ProcessBuilderEngine.Handle> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Handle submit(CommandLineToolInvocation invocation) {
        return () -> this.cache.getUnchecked(invocation);
    }

    public static interface Handle
    extends CommandLineToolExecutionHandle {
        public CommandLineToolExecutionResult getResult();
    }
}

