/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec.internal;

import dev.nokee.core.exec.CommandLineToolLogContent;
import dev.nokee.core.exec.internal.CommandLineToolOutputStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class CommandLineToolOutputStreamsIntertwineImpl
implements CommandLineToolOutputStreams {
    private final List<OutputSegment> outputSegments = new ArrayList<OutputSegment>();
    private final Object lock = new Object();
    private final SegmentingOutputStream out = new SegmentingOutputStream(OutputType.OUT);
    private final SegmentingOutputStream err = new SegmentingOutputStream(OutputType.ERR);

    public CommandLineToolLogContent getStandardOutputContent() {
        return CommandLineToolLogContent.of(this.outputSegments.stream().filter(OutputType.OUT).map(OutputSegment::getAsString).collect(Collectors.joining()));
    }

    public CommandLineToolLogContent getErrorOutputContent() {
        return CommandLineToolLogContent.of(this.outputSegments.stream().filter(OutputType.ERR).map(OutputSegment::getAsString).collect(Collectors.joining()));
    }

    public CommandLineToolLogContent getOutputContent() {
        return CommandLineToolLogContent.of(this.outputSegments.stream().map(OutputSegment::getAsString).collect(Collectors.joining()));
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.out;
    }

    @Override
    public OutputStream getErrorOutput() {
        return this.err;
    }

    private static final class OutputSegment {
        private final OutputType type;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        OutputSegment(OutputType type) {
            this.type = type;
        }

        void append(int b) {
            this.buffer.write(b);
        }

        String getAsString() {
            return this.buffer.toString();
        }
    }

    private static enum OutputType implements Predicate<OutputSegment>
    {
        OUT,
        ERR;


        @Override
        public boolean test(OutputSegment outputSegment) {
            return outputSegment.type == this;
        }
    }

    private class SegmentingOutputStream
    extends OutputStream {
        private final OutputType type;
        private OutputSegment currentSegment;

        SegmentingOutputStream(OutputType type) {
            this.type = type;
            this.currentSegment = new OutputSegment(type);
        }

        @Override
        public void write(int b) throws IOException {
            this.currentSegment.append(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = CommandLineToolOutputStreamsIntertwineImpl.this.lock;
            synchronized (object) {
                CommandLineToolOutputStreamsIntertwineImpl.this.outputSegments.add(this.currentSegment);
                this.currentSegment = new OutputSegment(this.type);
            }
        }
    }
}

