/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionEnvironmentVariableProvider;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;

public final class JavaHomeProvider
extends AbstractGradleExecutionProvider<File>
implements GradleExecutionEnvironmentVariableProvider {
    public static JavaHomeProvider current() {
        return JavaHomeProvider.fixed(JavaHomeProvider.class, SystemUtils.getJavaHome());
    }

    public static JavaHomeProvider inherited() {
        return JavaHomeProvider.noValue(JavaHomeProvider.class);
    }

    @Override
    public Map<String, String> getAsEnvironmentVariables() {
        return this.map(JavaHomeProvider::asEnvironmentVariables).orElseGet(Collections::emptyMap);
    }

    private static Map<String, String> asEnvironmentVariables(File javaHomeDirectory) {
        return Collections.singletonMap("JAVA_HOME", javaHomeDirectory.getAbsolutePath());
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (context.getEnvironmentVariables().isPresent() && ((Map)context.getEnvironmentVariables().get()).containsKey("JAVA_HOME")) {
            throw new InvalidRunnerConfigurationException("Please use GradleRunner#withJavaHomeDirectory(File) instead of using environment variables.");
        }
    }
}

