/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import dev.gradleplugins.runnerkit.providers.WorkingDirectoryProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.SystemUtils;

public final class GradleUserHomeDirectoryProvider
extends AbstractGradleExecutionProvider<File>
implements GradleExecutionCommandLineProvider {
    static final String TEST_KIT_DIR_SYS_PROP = "org.gradle.testkit.dir";

    public static GradleUserHomeDirectoryProvider testKitDirectory() {
        if (System.getProperties().containsKey(TEST_KIT_DIR_SYS_PROP)) {
            return GradleUserHomeDirectoryProvider.of(FileSystemUtils.canonicalize((File)new File(System.getProperty(TEST_KIT_DIR_SYS_PROP))));
        }
        return GradleUserHomeDirectoryProvider.of(FileSystemUtils.file((File)SystemUtils.getJavaIoTmpDir(), (Object[])new Object[]{".gradle-test-kit-".concat(SystemUtils.USER_NAME)}));
    }

    public static Function<GradleExecutionContext, File> relativeToGradleUserHome(String path) {
        return context -> FileSystemUtils.file((File)((File)context.getGradleUserHomeDirectory().get()), (Object[])new Object[]{path});
    }

    public static GradleUserHomeDirectoryProvider of(File gradleUserHomeDirectory) {
        return GradleUserHomeDirectoryProvider.fixed(GradleUserHomeDirectoryProvider.class, gradleUserHomeDirectory);
    }

    public static GradleUserHomeDirectoryProvider isolatedGradleUserHomeDirectory() {
        return GradleUserHomeDirectoryProvider.calculated(GradleUserHomeDirectoryProvider.class, WorkingDirectoryProvider.relativeToWorkingDirectory("user-home"));
    }

    @Override
    public List<String> getAsArguments() {
        return this.map(GradleUserHomeDirectoryProvider::asArguments).orElseGet(Collections::emptyList);
    }

    private static List<String> asArguments(File gradleUserHomeDirectory) {
        return Arrays.asList("--gradle-user-home", gradleUserHomeDirectory.getAbsolutePath());
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((List)context.getArguments().get()).stream().anyMatch(it -> it.startsWith("--gradle-user-home") || it.equals("-g"))) {
            throw new InvalidRunnerConfigurationException("Please use GradleRunner#withUserHomeDirectory(File) instead of using the command line flags.");
        }
    }
}

