/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.TaskOutcome;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class TaskOutcomeUtils {
    private static final Map<String, TaskOutcome> TASK_OUTCOME_MAPPING = new LinkedHashMap<String, TaskOutcome>();

    private TaskOutcomeUtils() {
    }

    public static String toString(TaskOutcome outcome) {
        return outcome.name().replace('_', '-');
    }

    public static TaskOutcome from(@Nullable String value) {
        if (value == null) {
            return TaskOutcome.SUCCESS;
        }
        return TASK_OUTCOME_MAPPING.computeIfAbsent(value, key -> {
            throw TaskOutcomeUtils.unknownTaskOutcomeException(key);
        });
    }

    private static IllegalArgumentException unknownTaskOutcomeException(String value) {
        return new IllegalArgumentException(String.format("Unknown task outcome '%s'. Known values: (%s).", value, String.join((CharSequence)", ", TASK_OUTCOME_MAPPING.keySet())));
    }

    public static boolean isSkipped(TaskOutcome outcome) {
        return !outcome.equals((Object)TaskOutcome.SUCCESS) && !outcome.equals((Object)TaskOutcome.FAILED);
    }

    static {
        for (TaskOutcome value : TaskOutcome.values()) {
            TASK_OUTCOME_MAPPING.put(TaskOutcomeUtils.toString(value), value);
        }
    }
}

