/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutor;
import dev.gradleplugins.runnerkit.providers.AfterExecuteActionsProvider;
import dev.gradleplugins.runnerkit.providers.BeforeExecuteActionsProvider;
import dev.gradleplugins.runnerkit.providers.BuildCacheProvider;
import dev.gradleplugins.runnerkit.providers.BuildScanProvider;
import dev.gradleplugins.runnerkit.providers.BuildScriptProvider;
import dev.gradleplugins.runnerkit.providers.CharacterEncodingProvider;
import dev.gradleplugins.runnerkit.providers.CommandLineArgumentsProvider;
import dev.gradleplugins.runnerkit.providers.ConsoleTypeProvider;
import dev.gradleplugins.runnerkit.providers.DaemonBaseDirectoryProvider;
import dev.gradleplugins.runnerkit.providers.DaemonIdleTimeoutProvider;
import dev.gradleplugins.runnerkit.providers.DeprecationChecksProvider;
import dev.gradleplugins.runnerkit.providers.EnvironmentVariablesProvider;
import dev.gradleplugins.runnerkit.providers.GradleDistributionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionProviderInternal;
import dev.gradleplugins.runnerkit.providers.GradleTasksProvider;
import dev.gradleplugins.runnerkit.providers.GradleUserHomeDirectoryProvider;
import dev.gradleplugins.runnerkit.providers.InitScriptsProvider;
import dev.gradleplugins.runnerkit.providers.InjectedClasspathProvider;
import dev.gradleplugins.runnerkit.providers.JavaHomeProvider;
import dev.gradleplugins.runnerkit.providers.LocaleProvider;
import dev.gradleplugins.runnerkit.providers.MissingSettingsFilePolicyProvider;
import dev.gradleplugins.runnerkit.providers.ProjectDirectoryProvider;
import dev.gradleplugins.runnerkit.providers.SettingsFileProvider;
import dev.gradleplugins.runnerkit.providers.StacktraceProvider;
import dev.gradleplugins.runnerkit.providers.StandardStreamProvider;
import dev.gradleplugins.runnerkit.providers.UserHomeDirectoryProvider;
import dev.gradleplugins.runnerkit.providers.WelcomeMessageProvider;
import dev.gradleplugins.runnerkit.providers.WorkingDirectoryProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

final class GradleRunnerParameters
implements GradleExecutionContext {
    private final Class<? extends GradleExecutor> executorType;
    @NonNull
    private BeforeExecuteActionsProvider beforeExecute = BeforeExecuteActionsProvider.empty();
    @NonNull
    private AfterExecuteActionsProvider afterExecute = AfterExecuteActionsProvider.empty();
    @NonNull
    private StandardStreamProvider standardOutput = StandardStreamProvider.forwardToStandardOutput();
    @NonNull
    private StandardStreamProvider standardError = StandardStreamProvider.forwardToStandardError();
    @NonNull
    private InjectedClasspathProvider injectedClasspath = InjectedClasspathProvider.empty();
    @NonNull
    private GradleDistributionProvider distribution = GradleDistributionProvider.executorDefault();
    @NonNull
    private WorkingDirectoryProvider workingDirectory = WorkingDirectoryProvider.unset();
    @NonNull
    private MissingSettingsFilePolicyProvider missingSettingsFilePolicy = MissingSettingsFilePolicyProvider.createWhenMissing();
    @NonNull
    private EnvironmentVariablesProvider environmentVariables = EnvironmentVariablesProvider.inherited();
    @NonNull
    private JavaHomeProvider javaHome = JavaHomeProvider.current();
    @NonNull
    private ConsoleTypeProvider consoleType = ConsoleTypeProvider.defaultConsole();
    @NonNull
    private GradleUserHomeDirectoryProvider gradleUserHomeDirectory = GradleUserHomeDirectoryProvider.testKitDirectory();
    @NonNull
    private StacktraceProvider stacktrace = StacktraceProvider.show();
    @NonNull
    private BuildCacheProvider buildCache = BuildCacheProvider.disabled();
    @NonNull
    private CommandLineArgumentsProvider arguments = CommandLineArgumentsProvider.empty();
    @NonNull
    private SettingsFileProvider settingsFile = SettingsFileProvider.unset();
    @NonNull
    private BuildScriptProvider buildScript = BuildScriptProvider.unset();
    @NonNull
    private ProjectDirectoryProvider projectDirectory = ProjectDirectoryProvider.useWorkingDirectoryImplicitly();
    @NonNull
    private InitScriptsProvider initScripts = InitScriptsProvider.empty();
    @NonNull
    private GradleTasksProvider tasks = GradleTasksProvider.empty();
    @NonNull
    private DeprecationChecksProvider deprecationChecks = DeprecationChecksProvider.fails();
    @NonNull
    private UserHomeDirectoryProvider userHomeDirectory = UserHomeDirectoryProvider.implicit();
    @NonNull
    private CharacterEncodingProvider defaultCharacterEncoding = CharacterEncodingProvider.defaultCharset();
    @NonNull
    private LocaleProvider defaultLocale = LocaleProvider.defaultLocale();
    @NonNull
    private WelcomeMessageProvider welcomeMessageRendering = WelcomeMessageProvider.disabled();
    @NonNull
    private DaemonBaseDirectoryProvider daemonBaseDirectory = DaemonBaseDirectoryProvider.testKitDaemonDirectory();
    @NonNull
    private DaemonIdleTimeoutProvider daemonIdleTimeout = DaemonIdleTimeoutProvider.testKitIdleTimeout();
    @NonNull
    private BuildScanProvider buildScan = BuildScanProvider.disabled();

    GradleRunnerParameters(Class<? extends GradleExecutor> executorType) {
        this.executorType = executorType;
    }

    public List<GradleExecutionProvider<?>> getExecutionParameters() {
        return GradleRunnerParameters.allExecutionParameters(this);
    }

    static List<GradleExecutionProvider<?>> allExecutionParameters(GradleExecutionContext parameters) {
        ArrayList result = new ArrayList();
        for (Method method : GradleExecutionContext.class.getMethods()) {
            if (!GradleExecutionProvider.class.isAssignableFrom(method.getReturnType())) continue;
            result.add((GradleExecutionProvider)method.invoke((Object)parameters, new Object[0]));
        }
        return result;
    }

    public List<String> getAllArguments() {
        return this.getExecutionParameters().stream().filter(GradleExecutionCommandLineProvider.class::isInstance).flatMap(GradleRunnerParameters::asArguments).collect(Collectors.toList());
    }

    private static Stream<String> asArguments(GradleExecutionProvider<?> parameter) {
        return ((GradleExecutionCommandLineProvider)parameter).getAsArguments().stream();
    }

    GradleRunnerParameters calculateValues() {
        GradleRunnerParameters.allExecutionParameters(this).stream().filter(GradleExecutionProviderInternal.class::isInstance).forEach(it -> ((GradleExecutionProviderInternal)it).calculateValue(this));
        return this;
    }

    public Class<? extends GradleExecutor> getExecutorType() {
        return this.executorType;
    }

    @NonNull
    public BeforeExecuteActionsProvider getBeforeExecute() {
        return this.beforeExecute;
    }

    @NonNull
    public AfterExecuteActionsProvider getAfterExecute() {
        return this.afterExecute;
    }

    @NonNull
    public StandardStreamProvider getStandardOutput() {
        return this.standardOutput;
    }

    @NonNull
    public StandardStreamProvider getStandardError() {
        return this.standardError;
    }

    @NonNull
    public InjectedClasspathProvider getInjectedClasspath() {
        return this.injectedClasspath;
    }

    @NonNull
    public GradleDistributionProvider getDistribution() {
        return this.distribution;
    }

    @NonNull
    public WorkingDirectoryProvider getWorkingDirectory() {
        return this.workingDirectory;
    }

    @NonNull
    public MissingSettingsFilePolicyProvider getMissingSettingsFilePolicy() {
        return this.missingSettingsFilePolicy;
    }

    @NonNull
    public EnvironmentVariablesProvider getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @NonNull
    public JavaHomeProvider getJavaHome() {
        return this.javaHome;
    }

    @NonNull
    public ConsoleTypeProvider getConsoleType() {
        return this.consoleType;
    }

    @NonNull
    public GradleUserHomeDirectoryProvider getGradleUserHomeDirectory() {
        return this.gradleUserHomeDirectory;
    }

    @NonNull
    public StacktraceProvider getStacktrace() {
        return this.stacktrace;
    }

    @NonNull
    public BuildCacheProvider getBuildCache() {
        return this.buildCache;
    }

    @NonNull
    public CommandLineArgumentsProvider getArguments() {
        return this.arguments;
    }

    @NonNull
    public SettingsFileProvider getSettingsFile() {
        return this.settingsFile;
    }

    @NonNull
    public BuildScriptProvider getBuildScript() {
        return this.buildScript;
    }

    @NonNull
    public ProjectDirectoryProvider getProjectDirectory() {
        return this.projectDirectory;
    }

    @NonNull
    public InitScriptsProvider getInitScripts() {
        return this.initScripts;
    }

    @NonNull
    public GradleTasksProvider getTasks() {
        return this.tasks;
    }

    @NonNull
    public DeprecationChecksProvider getDeprecationChecks() {
        return this.deprecationChecks;
    }

    @NonNull
    public UserHomeDirectoryProvider getUserHomeDirectory() {
        return this.userHomeDirectory;
    }

    @NonNull
    public CharacterEncodingProvider getDefaultCharacterEncoding() {
        return this.defaultCharacterEncoding;
    }

    @NonNull
    public LocaleProvider getDefaultLocale() {
        return this.defaultLocale;
    }

    @NonNull
    public WelcomeMessageProvider getWelcomeMessageRendering() {
        return this.welcomeMessageRendering;
    }

    @NonNull
    public DaemonBaseDirectoryProvider getDaemonBaseDirectory() {
        return this.daemonBaseDirectory;
    }

    @NonNull
    public DaemonIdleTimeoutProvider getDaemonIdleTimeout() {
        return this.daemonIdleTimeout;
    }

    @NonNull
    public BuildScanProvider getBuildScan() {
        return this.buildScan;
    }

    public void setBeforeExecute(@NonNull BeforeExecuteActionsProvider beforeExecute) {
        if (beforeExecute == null) {
            throw new NullPointerException("beforeExecute is marked non-null but is null");
        }
        this.beforeExecute = beforeExecute;
    }

    public void setAfterExecute(@NonNull AfterExecuteActionsProvider afterExecute) {
        if (afterExecute == null) {
            throw new NullPointerException("afterExecute is marked non-null but is null");
        }
        this.afterExecute = afterExecute;
    }

    public void setStandardOutput(@NonNull StandardStreamProvider standardOutput) {
        if (standardOutput == null) {
            throw new NullPointerException("standardOutput is marked non-null but is null");
        }
        this.standardOutput = standardOutput;
    }

    public void setStandardError(@NonNull StandardStreamProvider standardError) {
        if (standardError == null) {
            throw new NullPointerException("standardError is marked non-null but is null");
        }
        this.standardError = standardError;
    }

    public void setInjectedClasspath(@NonNull InjectedClasspathProvider injectedClasspath) {
        if (injectedClasspath == null) {
            throw new NullPointerException("injectedClasspath is marked non-null but is null");
        }
        this.injectedClasspath = injectedClasspath;
    }

    public void setDistribution(@NonNull GradleDistributionProvider distribution) {
        if (distribution == null) {
            throw new NullPointerException("distribution is marked non-null but is null");
        }
        this.distribution = distribution;
    }

    public void setWorkingDirectory(@NonNull WorkingDirectoryProvider workingDirectory) {
        if (workingDirectory == null) {
            throw new NullPointerException("workingDirectory is marked non-null but is null");
        }
        this.workingDirectory = workingDirectory;
    }

    public void setMissingSettingsFilePolicy(@NonNull MissingSettingsFilePolicyProvider missingSettingsFilePolicy) {
        if (missingSettingsFilePolicy == null) {
            throw new NullPointerException("missingSettingsFilePolicy is marked non-null but is null");
        }
        this.missingSettingsFilePolicy = missingSettingsFilePolicy;
    }

    public void setEnvironmentVariables(@NonNull EnvironmentVariablesProvider environmentVariables) {
        if (environmentVariables == null) {
            throw new NullPointerException("environmentVariables is marked non-null but is null");
        }
        this.environmentVariables = environmentVariables;
    }

    public void setJavaHome(@NonNull JavaHomeProvider javaHome) {
        if (javaHome == null) {
            throw new NullPointerException("javaHome is marked non-null but is null");
        }
        this.javaHome = javaHome;
    }

    public void setConsoleType(@NonNull ConsoleTypeProvider consoleType) {
        if (consoleType == null) {
            throw new NullPointerException("consoleType is marked non-null but is null");
        }
        this.consoleType = consoleType;
    }

    public void setGradleUserHomeDirectory(@NonNull GradleUserHomeDirectoryProvider gradleUserHomeDirectory) {
        if (gradleUserHomeDirectory == null) {
            throw new NullPointerException("gradleUserHomeDirectory is marked non-null but is null");
        }
        this.gradleUserHomeDirectory = gradleUserHomeDirectory;
    }

    public void setStacktrace(@NonNull StacktraceProvider stacktrace) {
        if (stacktrace == null) {
            throw new NullPointerException("stacktrace is marked non-null but is null");
        }
        this.stacktrace = stacktrace;
    }

    public void setBuildCache(@NonNull BuildCacheProvider buildCache) {
        if (buildCache == null) {
            throw new NullPointerException("buildCache is marked non-null but is null");
        }
        this.buildCache = buildCache;
    }

    public void setArguments(@NonNull CommandLineArgumentsProvider arguments) {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        this.arguments = arguments;
    }

    public void setSettingsFile(@NonNull SettingsFileProvider settingsFile) {
        if (settingsFile == null) {
            throw new NullPointerException("settingsFile is marked non-null but is null");
        }
        this.settingsFile = settingsFile;
    }

    public void setBuildScript(@NonNull BuildScriptProvider buildScript) {
        if (buildScript == null) {
            throw new NullPointerException("buildScript is marked non-null but is null");
        }
        this.buildScript = buildScript;
    }

    public void setProjectDirectory(@NonNull ProjectDirectoryProvider projectDirectory) {
        if (projectDirectory == null) {
            throw new NullPointerException("projectDirectory is marked non-null but is null");
        }
        this.projectDirectory = projectDirectory;
    }

    public void setInitScripts(@NonNull InitScriptsProvider initScripts) {
        if (initScripts == null) {
            throw new NullPointerException("initScripts is marked non-null but is null");
        }
        this.initScripts = initScripts;
    }

    public void setTasks(@NonNull GradleTasksProvider tasks) {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.tasks = tasks;
    }

    public void setDeprecationChecks(@NonNull DeprecationChecksProvider deprecationChecks) {
        if (deprecationChecks == null) {
            throw new NullPointerException("deprecationChecks is marked non-null but is null");
        }
        this.deprecationChecks = deprecationChecks;
    }

    public void setUserHomeDirectory(@NonNull UserHomeDirectoryProvider userHomeDirectory) {
        if (userHomeDirectory == null) {
            throw new NullPointerException("userHomeDirectory is marked non-null but is null");
        }
        this.userHomeDirectory = userHomeDirectory;
    }

    public void setDefaultCharacterEncoding(@NonNull CharacterEncodingProvider defaultCharacterEncoding) {
        if (defaultCharacterEncoding == null) {
            throw new NullPointerException("defaultCharacterEncoding is marked non-null but is null");
        }
        this.defaultCharacterEncoding = defaultCharacterEncoding;
    }

    public void setDefaultLocale(@NonNull LocaleProvider defaultLocale) {
        if (defaultLocale == null) {
            throw new NullPointerException("defaultLocale is marked non-null but is null");
        }
        this.defaultLocale = defaultLocale;
    }

    public void setWelcomeMessageRendering(@NonNull WelcomeMessageProvider welcomeMessageRendering) {
        if (welcomeMessageRendering == null) {
            throw new NullPointerException("welcomeMessageRendering is marked non-null but is null");
        }
        this.welcomeMessageRendering = welcomeMessageRendering;
    }

    public void setDaemonBaseDirectory(@NonNull DaemonBaseDirectoryProvider daemonBaseDirectory) {
        if (daemonBaseDirectory == null) {
            throw new NullPointerException("daemonBaseDirectory is marked non-null but is null");
        }
        this.daemonBaseDirectory = daemonBaseDirectory;
    }

    public void setDaemonIdleTimeout(@NonNull DaemonIdleTimeoutProvider daemonIdleTimeout) {
        if (daemonIdleTimeout == null) {
            throw new NullPointerException("daemonIdleTimeout is marked non-null but is null");
        }
        this.daemonIdleTimeout = daemonIdleTimeout;
    }

    public void setBuildScan(@NonNull BuildScanProvider buildScan) {
        if (buildScan == null) {
            throw new NullPointerException("buildScan is marked non-null but is null");
        }
        this.buildScan = buildScan;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleRunnerParameters)) {
            return false;
        }
        GradleRunnerParameters other = (GradleRunnerParameters)o;
        Class<? extends GradleExecutor> this$executorType = this.getExecutorType();
        Class<? extends GradleExecutor> other$executorType = other.getExecutorType();
        if (this$executorType == null ? other$executorType != null : !this$executorType.equals(other$executorType)) {
            return false;
        }
        BeforeExecuteActionsProvider this$beforeExecute = this.getBeforeExecute();
        BeforeExecuteActionsProvider other$beforeExecute = other.getBeforeExecute();
        if (this$beforeExecute == null ? other$beforeExecute != null : !((Object)this$beforeExecute).equals(other$beforeExecute)) {
            return false;
        }
        AfterExecuteActionsProvider this$afterExecute = this.getAfterExecute();
        AfterExecuteActionsProvider other$afterExecute = other.getAfterExecute();
        if (this$afterExecute == null ? other$afterExecute != null : !((Object)this$afterExecute).equals(other$afterExecute)) {
            return false;
        }
        StandardStreamProvider this$standardOutput = this.getStandardOutput();
        StandardStreamProvider other$standardOutput = other.getStandardOutput();
        if (this$standardOutput == null ? other$standardOutput != null : !((Object)this$standardOutput).equals(other$standardOutput)) {
            return false;
        }
        StandardStreamProvider this$standardError = this.getStandardError();
        StandardStreamProvider other$standardError = other.getStandardError();
        if (this$standardError == null ? other$standardError != null : !((Object)this$standardError).equals(other$standardError)) {
            return false;
        }
        InjectedClasspathProvider this$injectedClasspath = this.getInjectedClasspath();
        InjectedClasspathProvider other$injectedClasspath = other.getInjectedClasspath();
        if (this$injectedClasspath == null ? other$injectedClasspath != null : !((Object)this$injectedClasspath).equals(other$injectedClasspath)) {
            return false;
        }
        GradleDistributionProvider this$distribution = this.getDistribution();
        GradleDistributionProvider other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !((Object)this$distribution).equals(other$distribution)) {
            return false;
        }
        WorkingDirectoryProvider this$workingDirectory = this.getWorkingDirectory();
        WorkingDirectoryProvider other$workingDirectory = other.getWorkingDirectory();
        if (this$workingDirectory == null ? other$workingDirectory != null : !((Object)this$workingDirectory).equals(other$workingDirectory)) {
            return false;
        }
        MissingSettingsFilePolicyProvider this$missingSettingsFilePolicy = this.getMissingSettingsFilePolicy();
        MissingSettingsFilePolicyProvider other$missingSettingsFilePolicy = other.getMissingSettingsFilePolicy();
        if (this$missingSettingsFilePolicy == null ? other$missingSettingsFilePolicy != null : !((Object)this$missingSettingsFilePolicy).equals(other$missingSettingsFilePolicy)) {
            return false;
        }
        EnvironmentVariablesProvider this$environmentVariables = this.getEnvironmentVariables();
        EnvironmentVariablesProvider other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        JavaHomeProvider this$javaHome = this.getJavaHome();
        JavaHomeProvider other$javaHome = other.getJavaHome();
        if (this$javaHome == null ? other$javaHome != null : !((Object)this$javaHome).equals(other$javaHome)) {
            return false;
        }
        ConsoleTypeProvider this$consoleType = this.getConsoleType();
        ConsoleTypeProvider other$consoleType = other.getConsoleType();
        if (this$consoleType == null ? other$consoleType != null : !((Object)this$consoleType).equals(other$consoleType)) {
            return false;
        }
        GradleUserHomeDirectoryProvider this$gradleUserHomeDirectory = this.getGradleUserHomeDirectory();
        GradleUserHomeDirectoryProvider other$gradleUserHomeDirectory = other.getGradleUserHomeDirectory();
        if (this$gradleUserHomeDirectory == null ? other$gradleUserHomeDirectory != null : !((Object)this$gradleUserHomeDirectory).equals(other$gradleUserHomeDirectory)) {
            return false;
        }
        StacktraceProvider this$stacktrace = this.getStacktrace();
        StacktraceProvider other$stacktrace = other.getStacktrace();
        if (this$stacktrace == null ? other$stacktrace != null : !((Object)this$stacktrace).equals(other$stacktrace)) {
            return false;
        }
        BuildCacheProvider this$buildCache = this.getBuildCache();
        BuildCacheProvider other$buildCache = other.getBuildCache();
        if (this$buildCache == null ? other$buildCache != null : !((Object)this$buildCache).equals(other$buildCache)) {
            return false;
        }
        CommandLineArgumentsProvider this$arguments = this.getArguments();
        CommandLineArgumentsProvider other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        SettingsFileProvider this$settingsFile = this.getSettingsFile();
        SettingsFileProvider other$settingsFile = other.getSettingsFile();
        if (this$settingsFile == null ? other$settingsFile != null : !((Object)this$settingsFile).equals(other$settingsFile)) {
            return false;
        }
        BuildScriptProvider this$buildScript = this.getBuildScript();
        BuildScriptProvider other$buildScript = other.getBuildScript();
        if (this$buildScript == null ? other$buildScript != null : !((Object)this$buildScript).equals(other$buildScript)) {
            return false;
        }
        ProjectDirectoryProvider this$projectDirectory = this.getProjectDirectory();
        ProjectDirectoryProvider other$projectDirectory = other.getProjectDirectory();
        if (this$projectDirectory == null ? other$projectDirectory != null : !((Object)this$projectDirectory).equals(other$projectDirectory)) {
            return false;
        }
        InitScriptsProvider this$initScripts = this.getInitScripts();
        InitScriptsProvider other$initScripts = other.getInitScripts();
        if (this$initScripts == null ? other$initScripts != null : !((Object)this$initScripts).equals(other$initScripts)) {
            return false;
        }
        GradleTasksProvider this$tasks = this.getTasks();
        GradleTasksProvider other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        DeprecationChecksProvider this$deprecationChecks = this.getDeprecationChecks();
        DeprecationChecksProvider other$deprecationChecks = other.getDeprecationChecks();
        if (this$deprecationChecks == null ? other$deprecationChecks != null : !((Object)this$deprecationChecks).equals(other$deprecationChecks)) {
            return false;
        }
        UserHomeDirectoryProvider this$userHomeDirectory = this.getUserHomeDirectory();
        UserHomeDirectoryProvider other$userHomeDirectory = other.getUserHomeDirectory();
        if (this$userHomeDirectory == null ? other$userHomeDirectory != null : !((Object)this$userHomeDirectory).equals(other$userHomeDirectory)) {
            return false;
        }
        CharacterEncodingProvider this$defaultCharacterEncoding = this.getDefaultCharacterEncoding();
        CharacterEncodingProvider other$defaultCharacterEncoding = other.getDefaultCharacterEncoding();
        if (this$defaultCharacterEncoding == null ? other$defaultCharacterEncoding != null : !((Object)this$defaultCharacterEncoding).equals(other$defaultCharacterEncoding)) {
            return false;
        }
        LocaleProvider this$defaultLocale = this.getDefaultLocale();
        LocaleProvider other$defaultLocale = other.getDefaultLocale();
        if (this$defaultLocale == null ? other$defaultLocale != null : !((Object)this$defaultLocale).equals(other$defaultLocale)) {
            return false;
        }
        WelcomeMessageProvider this$welcomeMessageRendering = this.getWelcomeMessageRendering();
        WelcomeMessageProvider other$welcomeMessageRendering = other.getWelcomeMessageRendering();
        if (this$welcomeMessageRendering == null ? other$welcomeMessageRendering != null : !((Object)this$welcomeMessageRendering).equals(other$welcomeMessageRendering)) {
            return false;
        }
        DaemonBaseDirectoryProvider this$daemonBaseDirectory = this.getDaemonBaseDirectory();
        DaemonBaseDirectoryProvider other$daemonBaseDirectory = other.getDaemonBaseDirectory();
        if (this$daemonBaseDirectory == null ? other$daemonBaseDirectory != null : !((Object)this$daemonBaseDirectory).equals(other$daemonBaseDirectory)) {
            return false;
        }
        DaemonIdleTimeoutProvider this$daemonIdleTimeout = this.getDaemonIdleTimeout();
        DaemonIdleTimeoutProvider other$daemonIdleTimeout = other.getDaemonIdleTimeout();
        if (this$daemonIdleTimeout == null ? other$daemonIdleTimeout != null : !((Object)this$daemonIdleTimeout).equals(other$daemonIdleTimeout)) {
            return false;
        }
        BuildScanProvider this$buildScan = this.getBuildScan();
        BuildScanProvider other$buildScan = other.getBuildScan();
        return !(this$buildScan == null ? other$buildScan != null : !((Object)this$buildScan).equals(other$buildScan));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends GradleExecutor> $executorType = this.getExecutorType();
        result = result * 59 + ($executorType == null ? 43 : $executorType.hashCode());
        BeforeExecuteActionsProvider $beforeExecute = this.getBeforeExecute();
        result = result * 59 + ($beforeExecute == null ? 43 : ((Object)$beforeExecute).hashCode());
        AfterExecuteActionsProvider $afterExecute = this.getAfterExecute();
        result = result * 59 + ($afterExecute == null ? 43 : ((Object)$afterExecute).hashCode());
        StandardStreamProvider $standardOutput = this.getStandardOutput();
        result = result * 59 + ($standardOutput == null ? 43 : ((Object)$standardOutput).hashCode());
        StandardStreamProvider $standardError = this.getStandardError();
        result = result * 59 + ($standardError == null ? 43 : ((Object)$standardError).hashCode());
        InjectedClasspathProvider $injectedClasspath = this.getInjectedClasspath();
        result = result * 59 + ($injectedClasspath == null ? 43 : ((Object)$injectedClasspath).hashCode());
        GradleDistributionProvider $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : ((Object)$distribution).hashCode());
        WorkingDirectoryProvider $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : ((Object)$workingDirectory).hashCode());
        MissingSettingsFilePolicyProvider $missingSettingsFilePolicy = this.getMissingSettingsFilePolicy();
        result = result * 59 + ($missingSettingsFilePolicy == null ? 43 : ((Object)$missingSettingsFilePolicy).hashCode());
        EnvironmentVariablesProvider $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        JavaHomeProvider $javaHome = this.getJavaHome();
        result = result * 59 + ($javaHome == null ? 43 : ((Object)$javaHome).hashCode());
        ConsoleTypeProvider $consoleType = this.getConsoleType();
        result = result * 59 + ($consoleType == null ? 43 : ((Object)$consoleType).hashCode());
        GradleUserHomeDirectoryProvider $gradleUserHomeDirectory = this.getGradleUserHomeDirectory();
        result = result * 59 + ($gradleUserHomeDirectory == null ? 43 : ((Object)$gradleUserHomeDirectory).hashCode());
        StacktraceProvider $stacktrace = this.getStacktrace();
        result = result * 59 + ($stacktrace == null ? 43 : ((Object)$stacktrace).hashCode());
        BuildCacheProvider $buildCache = this.getBuildCache();
        result = result * 59 + ($buildCache == null ? 43 : ((Object)$buildCache).hashCode());
        CommandLineArgumentsProvider $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        SettingsFileProvider $settingsFile = this.getSettingsFile();
        result = result * 59 + ($settingsFile == null ? 43 : ((Object)$settingsFile).hashCode());
        BuildScriptProvider $buildScript = this.getBuildScript();
        result = result * 59 + ($buildScript == null ? 43 : ((Object)$buildScript).hashCode());
        ProjectDirectoryProvider $projectDirectory = this.getProjectDirectory();
        result = result * 59 + ($projectDirectory == null ? 43 : ((Object)$projectDirectory).hashCode());
        InitScriptsProvider $initScripts = this.getInitScripts();
        result = result * 59 + ($initScripts == null ? 43 : ((Object)$initScripts).hashCode());
        GradleTasksProvider $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        DeprecationChecksProvider $deprecationChecks = this.getDeprecationChecks();
        result = result * 59 + ($deprecationChecks == null ? 43 : ((Object)$deprecationChecks).hashCode());
        UserHomeDirectoryProvider $userHomeDirectory = this.getUserHomeDirectory();
        result = result * 59 + ($userHomeDirectory == null ? 43 : ((Object)$userHomeDirectory).hashCode());
        CharacterEncodingProvider $defaultCharacterEncoding = this.getDefaultCharacterEncoding();
        result = result * 59 + ($defaultCharacterEncoding == null ? 43 : ((Object)$defaultCharacterEncoding).hashCode());
        LocaleProvider $defaultLocale = this.getDefaultLocale();
        result = result * 59 + ($defaultLocale == null ? 43 : ((Object)$defaultLocale).hashCode());
        WelcomeMessageProvider $welcomeMessageRendering = this.getWelcomeMessageRendering();
        result = result * 59 + ($welcomeMessageRendering == null ? 43 : ((Object)$welcomeMessageRendering).hashCode());
        DaemonBaseDirectoryProvider $daemonBaseDirectory = this.getDaemonBaseDirectory();
        result = result * 59 + ($daemonBaseDirectory == null ? 43 : ((Object)$daemonBaseDirectory).hashCode());
        DaemonIdleTimeoutProvider $daemonIdleTimeout = this.getDaemonIdleTimeout();
        result = result * 59 + ($daemonIdleTimeout == null ? 43 : ((Object)$daemonIdleTimeout).hashCode());
        BuildScanProvider $buildScan = this.getBuildScan();
        result = result * 59 + ($buildScan == null ? 43 : ((Object)$buildScan).hashCode());
        return result;
    }

    public String toString() {
        return "GradleRunnerParameters(executorType=" + this.getExecutorType() + ", beforeExecute=" + this.getBeforeExecute() + ", afterExecute=" + this.getAfterExecute() + ", standardOutput=" + this.getStandardOutput() + ", standardError=" + this.getStandardError() + ", injectedClasspath=" + this.getInjectedClasspath() + ", distribution=" + this.getDistribution() + ", workingDirectory=" + this.getWorkingDirectory() + ", missingSettingsFilePolicy=" + this.getMissingSettingsFilePolicy() + ", environmentVariables=" + this.getEnvironmentVariables() + ", javaHome=" + this.getJavaHome() + ", consoleType=" + this.getConsoleType() + ", gradleUserHomeDirectory=" + this.getGradleUserHomeDirectory() + ", stacktrace=" + this.getStacktrace() + ", buildCache=" + this.getBuildCache() + ", arguments=" + this.getArguments() + ", settingsFile=" + this.getSettingsFile() + ", buildScript=" + this.getBuildScript() + ", projectDirectory=" + this.getProjectDirectory() + ", initScripts=" + this.getInitScripts() + ", tasks=" + this.getTasks() + ", deprecationChecks=" + this.getDeprecationChecks() + ", userHomeDirectory=" + this.getUserHomeDirectory() + ", defaultCharacterEncoding=" + this.getDefaultCharacterEncoding() + ", defaultLocale=" + this.getDefaultLocale() + ", welcomeMessageRendering=" + this.getWelcomeMessageRendering() + ", daemonBaseDirectory=" + this.getDaemonBaseDirectory() + ", daemonIdleTimeout=" + this.getDaemonIdleTimeout() + ", buildScan=" + this.getBuildScan() + ")";
    }

    public GradleRunnerParameters(Class<? extends GradleExecutor> executorType, @NonNull BeforeExecuteActionsProvider beforeExecute, @NonNull AfterExecuteActionsProvider afterExecute, @NonNull StandardStreamProvider standardOutput, @NonNull StandardStreamProvider standardError, @NonNull InjectedClasspathProvider injectedClasspath, @NonNull GradleDistributionProvider distribution, @NonNull WorkingDirectoryProvider workingDirectory, @NonNull MissingSettingsFilePolicyProvider missingSettingsFilePolicy, @NonNull EnvironmentVariablesProvider environmentVariables, @NonNull JavaHomeProvider javaHome, @NonNull ConsoleTypeProvider consoleType, @NonNull GradleUserHomeDirectoryProvider gradleUserHomeDirectory, @NonNull StacktraceProvider stacktrace, @NonNull BuildCacheProvider buildCache, @NonNull CommandLineArgumentsProvider arguments, @NonNull SettingsFileProvider settingsFile, @NonNull BuildScriptProvider buildScript, @NonNull ProjectDirectoryProvider projectDirectory, @NonNull InitScriptsProvider initScripts, @NonNull GradleTasksProvider tasks, @NonNull DeprecationChecksProvider deprecationChecks, @NonNull UserHomeDirectoryProvider userHomeDirectory, @NonNull CharacterEncodingProvider defaultCharacterEncoding, @NonNull LocaleProvider defaultLocale, @NonNull WelcomeMessageProvider welcomeMessageRendering, @NonNull DaemonBaseDirectoryProvider daemonBaseDirectory, @NonNull DaemonIdleTimeoutProvider daemonIdleTimeout, @NonNull BuildScanProvider buildScan) {
        if (beforeExecute == null) {
            throw new NullPointerException("beforeExecute is marked non-null but is null");
        }
        if (afterExecute == null) {
            throw new NullPointerException("afterExecute is marked non-null but is null");
        }
        if (standardOutput == null) {
            throw new NullPointerException("standardOutput is marked non-null but is null");
        }
        if (standardError == null) {
            throw new NullPointerException("standardError is marked non-null but is null");
        }
        if (injectedClasspath == null) {
            throw new NullPointerException("injectedClasspath is marked non-null but is null");
        }
        if (distribution == null) {
            throw new NullPointerException("distribution is marked non-null but is null");
        }
        if (workingDirectory == null) {
            throw new NullPointerException("workingDirectory is marked non-null but is null");
        }
        if (missingSettingsFilePolicy == null) {
            throw new NullPointerException("missingSettingsFilePolicy is marked non-null but is null");
        }
        if (environmentVariables == null) {
            throw new NullPointerException("environmentVariables is marked non-null but is null");
        }
        if (javaHome == null) {
            throw new NullPointerException("javaHome is marked non-null but is null");
        }
        if (consoleType == null) {
            throw new NullPointerException("consoleType is marked non-null but is null");
        }
        if (gradleUserHomeDirectory == null) {
            throw new NullPointerException("gradleUserHomeDirectory is marked non-null but is null");
        }
        if (stacktrace == null) {
            throw new NullPointerException("stacktrace is marked non-null but is null");
        }
        if (buildCache == null) {
            throw new NullPointerException("buildCache is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        if (settingsFile == null) {
            throw new NullPointerException("settingsFile is marked non-null but is null");
        }
        if (buildScript == null) {
            throw new NullPointerException("buildScript is marked non-null but is null");
        }
        if (projectDirectory == null) {
            throw new NullPointerException("projectDirectory is marked non-null but is null");
        }
        if (initScripts == null) {
            throw new NullPointerException("initScripts is marked non-null but is null");
        }
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        if (deprecationChecks == null) {
            throw new NullPointerException("deprecationChecks is marked non-null but is null");
        }
        if (userHomeDirectory == null) {
            throw new NullPointerException("userHomeDirectory is marked non-null but is null");
        }
        if (defaultCharacterEncoding == null) {
            throw new NullPointerException("defaultCharacterEncoding is marked non-null but is null");
        }
        if (defaultLocale == null) {
            throw new NullPointerException("defaultLocale is marked non-null but is null");
        }
        if (welcomeMessageRendering == null) {
            throw new NullPointerException("welcomeMessageRendering is marked non-null but is null");
        }
        if (daemonBaseDirectory == null) {
            throw new NullPointerException("daemonBaseDirectory is marked non-null but is null");
        }
        if (daemonIdleTimeout == null) {
            throw new NullPointerException("daemonIdleTimeout is marked non-null but is null");
        }
        if (buildScan == null) {
            throw new NullPointerException("buildScan is marked non-null but is null");
        }
        this.executorType = executorType;
        this.beforeExecute = beforeExecute;
        this.afterExecute = afterExecute;
        this.standardOutput = standardOutput;
        this.standardError = standardError;
        this.injectedClasspath = injectedClasspath;
        this.distribution = distribution;
        this.workingDirectory = workingDirectory;
        this.missingSettingsFilePolicy = missingSettingsFilePolicy;
        this.environmentVariables = environmentVariables;
        this.javaHome = javaHome;
        this.consoleType = consoleType;
        this.gradleUserHomeDirectory = gradleUserHomeDirectory;
        this.stacktrace = stacktrace;
        this.buildCache = buildCache;
        this.arguments = arguments;
        this.settingsFile = settingsFile;
        this.buildScript = buildScript;
        this.projectDirectory = projectDirectory;
        this.initScripts = initScripts;
        this.tasks = tasks;
        this.deprecationChecks = deprecationChecks;
        this.userHomeDirectory = userHomeDirectory;
        this.defaultCharacterEncoding = defaultCharacterEncoding;
        this.defaultLocale = defaultLocale;
        this.welcomeMessageRendering = welcomeMessageRendering;
        this.daemonBaseDirectory = daemonBaseDirectory;
        this.daemonIdleTimeout = daemonIdleTimeout;
        this.buildScan = buildScan;
    }

    public GradleRunnerParameters withBeforeExecute(@NonNull BeforeExecuteActionsProvider beforeExecute) {
        if (beforeExecute == null) {
            throw new NullPointerException("beforeExecute is marked non-null but is null");
        }
        return this.beforeExecute == beforeExecute ? this : new GradleRunnerParameters(this.executorType, beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withAfterExecute(@NonNull AfterExecuteActionsProvider afterExecute) {
        if (afterExecute == null) {
            throw new NullPointerException("afterExecute is marked non-null but is null");
        }
        return this.afterExecute == afterExecute ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withStandardOutput(@NonNull StandardStreamProvider standardOutput) {
        if (standardOutput == null) {
            throw new NullPointerException("standardOutput is marked non-null but is null");
        }
        return this.standardOutput == standardOutput ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withStandardError(@NonNull StandardStreamProvider standardError) {
        if (standardError == null) {
            throw new NullPointerException("standardError is marked non-null but is null");
        }
        return this.standardError == standardError ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withInjectedClasspath(@NonNull InjectedClasspathProvider injectedClasspath) {
        if (injectedClasspath == null) {
            throw new NullPointerException("injectedClasspath is marked non-null but is null");
        }
        return this.injectedClasspath == injectedClasspath ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withDistribution(@NonNull GradleDistributionProvider distribution) {
        if (distribution == null) {
            throw new NullPointerException("distribution is marked non-null but is null");
        }
        return this.distribution == distribution ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withWorkingDirectory(@NonNull WorkingDirectoryProvider workingDirectory) {
        if (workingDirectory == null) {
            throw new NullPointerException("workingDirectory is marked non-null but is null");
        }
        return this.workingDirectory == workingDirectory ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withMissingSettingsFilePolicy(@NonNull MissingSettingsFilePolicyProvider missingSettingsFilePolicy) {
        if (missingSettingsFilePolicy == null) {
            throw new NullPointerException("missingSettingsFilePolicy is marked non-null but is null");
        }
        return this.missingSettingsFilePolicy == missingSettingsFilePolicy ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withEnvironmentVariables(@NonNull EnvironmentVariablesProvider environmentVariables) {
        if (environmentVariables == null) {
            throw new NullPointerException("environmentVariables is marked non-null but is null");
        }
        return this.environmentVariables == environmentVariables ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withJavaHome(@NonNull JavaHomeProvider javaHome) {
        if (javaHome == null) {
            throw new NullPointerException("javaHome is marked non-null but is null");
        }
        return this.javaHome == javaHome ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withConsoleType(@NonNull ConsoleTypeProvider consoleType) {
        if (consoleType == null) {
            throw new NullPointerException("consoleType is marked non-null but is null");
        }
        return this.consoleType == consoleType ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withGradleUserHomeDirectory(@NonNull GradleUserHomeDirectoryProvider gradleUserHomeDirectory) {
        if (gradleUserHomeDirectory == null) {
            throw new NullPointerException("gradleUserHomeDirectory is marked non-null but is null");
        }
        return this.gradleUserHomeDirectory == gradleUserHomeDirectory ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withStacktrace(@NonNull StacktraceProvider stacktrace) {
        if (stacktrace == null) {
            throw new NullPointerException("stacktrace is marked non-null but is null");
        }
        return this.stacktrace == stacktrace ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withBuildCache(@NonNull BuildCacheProvider buildCache) {
        if (buildCache == null) {
            throw new NullPointerException("buildCache is marked non-null but is null");
        }
        return this.buildCache == buildCache ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withArguments(@NonNull CommandLineArgumentsProvider arguments) {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return this.arguments == arguments ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withSettingsFile(@NonNull SettingsFileProvider settingsFile) {
        if (settingsFile == null) {
            throw new NullPointerException("settingsFile is marked non-null but is null");
        }
        return this.settingsFile == settingsFile ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withBuildScript(@NonNull BuildScriptProvider buildScript) {
        if (buildScript == null) {
            throw new NullPointerException("buildScript is marked non-null but is null");
        }
        return this.buildScript == buildScript ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withProjectDirectory(@NonNull ProjectDirectoryProvider projectDirectory) {
        if (projectDirectory == null) {
            throw new NullPointerException("projectDirectory is marked non-null but is null");
        }
        return this.projectDirectory == projectDirectory ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withInitScripts(@NonNull InitScriptsProvider initScripts) {
        if (initScripts == null) {
            throw new NullPointerException("initScripts is marked non-null but is null");
        }
        return this.initScripts == initScripts ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withTasks(@NonNull GradleTasksProvider tasks) {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        return this.tasks == tasks ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withDeprecationChecks(@NonNull DeprecationChecksProvider deprecationChecks) {
        if (deprecationChecks == null) {
            throw new NullPointerException("deprecationChecks is marked non-null but is null");
        }
        return this.deprecationChecks == deprecationChecks ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withUserHomeDirectory(@NonNull UserHomeDirectoryProvider userHomeDirectory) {
        if (userHomeDirectory == null) {
            throw new NullPointerException("userHomeDirectory is marked non-null but is null");
        }
        return this.userHomeDirectory == userHomeDirectory ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withDefaultCharacterEncoding(@NonNull CharacterEncodingProvider defaultCharacterEncoding) {
        if (defaultCharacterEncoding == null) {
            throw new NullPointerException("defaultCharacterEncoding is marked non-null but is null");
        }
        return this.defaultCharacterEncoding == defaultCharacterEncoding ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withDefaultLocale(@NonNull LocaleProvider defaultLocale) {
        if (defaultLocale == null) {
            throw new NullPointerException("defaultLocale is marked non-null but is null");
        }
        return this.defaultLocale == defaultLocale ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withWelcomeMessageRendering(@NonNull WelcomeMessageProvider welcomeMessageRendering) {
        if (welcomeMessageRendering == null) {
            throw new NullPointerException("welcomeMessageRendering is marked non-null but is null");
        }
        return this.welcomeMessageRendering == welcomeMessageRendering ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withDaemonBaseDirectory(@NonNull DaemonBaseDirectoryProvider daemonBaseDirectory) {
        if (daemonBaseDirectory == null) {
            throw new NullPointerException("daemonBaseDirectory is marked non-null but is null");
        }
        return this.daemonBaseDirectory == daemonBaseDirectory ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, daemonBaseDirectory, this.daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withDaemonIdleTimeout(@NonNull DaemonIdleTimeoutProvider daemonIdleTimeout) {
        if (daemonIdleTimeout == null) {
            throw new NullPointerException("daemonIdleTimeout is marked non-null but is null");
        }
        return this.daemonIdleTimeout == daemonIdleTimeout ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, daemonIdleTimeout, this.buildScan);
    }

    public GradleRunnerParameters withBuildScan(@NonNull BuildScanProvider buildScan) {
        if (buildScan == null) {
            throw new NullPointerException("buildScan is marked non-null but is null");
        }
        return this.buildScan == buildScan ? this : new GradleRunnerParameters(this.executorType, this.beforeExecute, this.afterExecute, this.standardOutput, this.standardError, this.injectedClasspath, this.distribution, this.workingDirectory, this.missingSettingsFilePolicy, this.environmentVariables, this.javaHome, this.consoleType, this.gradleUserHomeDirectory, this.stacktrace, this.buildCache, this.arguments, this.settingsFile, this.buildScript, this.projectDirectory, this.initScripts, this.tasks, this.deprecationChecks, this.userHomeDirectory, this.defaultCharacterEncoding, this.defaultLocale, this.welcomeMessageRendering, this.daemonBaseDirectory, this.daemonIdleTimeout, buildScan);
    }
}

