/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.BuildTask;
import dev.gradleplugins.runnerkit.TaskOutcomeUtils;
import dev.gradleplugins.runnerkit.TaskPath;
import java.util.Map;

public final class ActionableTaskCount {
    private final long executedTaskCount;
    private final long upToDateTaskCount;

    private ActionableTaskCount(long executedTaskCount, long upToDateTaskCount) {
        this.executedTaskCount = executedTaskCount;
        this.upToDateTaskCount = upToDateTaskCount;
    }

    public long getActionableTaskCount() {
        return this.executedTaskCount + this.upToDateTaskCount;
    }

    public static ActionableTaskCount of(long executedTaskCount, long upToDateTaskCount) {
        return new ActionableTaskCount(executedTaskCount, upToDateTaskCount);
    }

    public static ActionableTaskCount from(Map<TaskPath, BuildTask> discoveredTasks) {
        return new ActionableTaskCount(discoveredTasks.values().stream().filter(ActionableTaskCount::isExecuted).count(), discoveredTasks.values().stream().filter(ActionableTaskCount::isUpToDate).count());
    }

    private static boolean isExecuted(BuildTask task) {
        return !TaskOutcomeUtils.isSkipped(task.getOutcome());
    }

    private static boolean isUpToDate(BuildTask task) {
        return TaskOutcomeUtils.isSkipped(task.getOutcome());
    }

    public void toString(StringBuilder result) {
        result.append(this.getActionableTaskCount()).append(" actionable ");
        if (this.getActionableTaskCount() > 1L) {
            result.append("tasks");
        } else {
            result.append("task");
        }
        result.append(": ").append(this.getExecutedTaskCount()).append(" executed");
        if (this.getUpToDateTaskCount() > 0L) {
            result.append(", ").append(this.getUpToDateTaskCount()).append(" up-to-date");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionableTaskCount)) {
            return false;
        }
        ActionableTaskCount other = (ActionableTaskCount)o;
        if (this.getExecutedTaskCount() != other.getExecutedTaskCount()) {
            return false;
        }
        return this.getUpToDateTaskCount() == other.getUpToDateTaskCount();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $executedTaskCount = this.getExecutedTaskCount();
        result = result * 59 + (int)($executedTaskCount >>> 32 ^ $executedTaskCount);
        long $upToDateTaskCount = this.getUpToDateTaskCount();
        result = result * 59 + (int)($upToDateTaskCount >>> 32 ^ $upToDateTaskCount);
        return result;
    }

    public long getExecutedTaskCount() {
        return this.executedTaskCount;
    }

    public long getUpToDateTaskCount() {
        return this.upToDateTaskCount;
    }
}

