/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.fixtures.file.FileSystemUtils;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutor;
import dev.gradleplugins.runnerkit.GradleRunner;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.test.fixtures.file.TestFile;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistribution;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleDistributionFactory;
import dev.gradleplugins.test.fixtures.gradle.executer.GradleExecuter;
import dev.gradleplugins.test.fixtures.gradle.executer.internal.DefaultGradleDistribution;
import dev.nokee.core.exec.CommandLine;
import dev.nokee.core.exec.CommandLineToolLogContent;
import java.io.File;
import java.net.URI;
import java.nio.file.LinkOption;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.JavaVersion;
import org.gradle.cache.internal.CacheVersion;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.util.GradleVersion;

public final class GradleDistributionProvider
extends AbstractGradleExecutionProvider<GradleDistribution> {
    public static GradleDistributionProvider fromGradleRunner() {
        return GradleDistributionProvider.supplied(GradleDistributionProvider.class, () -> GradleDistributionProvider.findGradleInstallFromGradleRunner());
    }

    static DefaultGradleDistribution findGradleInstallFromGradleRunner() {
        GradleInstallation gradleInstallation = CurrentGradleInstallation.get();
        if (gradleInstallation == null) {
            String messagePrefix = "Could not find a Gradle installation to use based on the location of the GradleRunner class";
            try {
                File classpathForClass = ClasspathUtil.getClasspathForClass(GradleRunner.class);
                messagePrefix = messagePrefix + ": " + classpathForClass.getAbsolutePath();
            }
            catch (Exception classpathForClass) {
                // empty catch block
            }
            throw new InvalidRunnerConfigurationException(messagePrefix + ". Please specify a Gradle runtime to use via GradleRunner.withGradleVersion() or similar.");
        }
        File binDirectory = FileSystemUtils.file((File)gradleInstallation.getGradleHome(), (Object[])new Object[]{"bin"});
        File gradleExe = FileSystemUtils.file((File)binDirectory, (Object[])new Object[]{"gradle"});
        GradleVersion gradleVersion = GradleDistributionProvider.findVersion(CommandLine.of((Object[])new Object[]{gradleExe, "--version"}).execute().waitFor().assertNormalExitValue().getStandardOutput());
        return new DefaultGradleDistribution(gradleVersion, TestFile.of((File)gradleInstallation.getGradleHome(), (LinkOption[])new LinkOption[0]), TestFile.of((File)binDirectory, (LinkOption[])new LinkOption[0]));
    }

    public static GradleVersion findVersion(CommandLineToolLogContent output) {
        return GradleVersion.version((String)output.getLines().stream().filter(it -> it.startsWith("Gradle ")).map((? super T it) -> it.replace("Gradle ", "")).findFirst().orElseThrow(RuntimeException::new));
    }

    public static GradleDistributionProvider fromWrapper(Supplier<File> baseDirectory) {
        return GradleDistributionProvider.supplied(GradleDistributionProvider.class, () -> GradleDistributionFactory.wrapper((File)((File)baseDirectory.get())));
    }

    public static GradleDistributionProvider fromGradleWrapper() {
        return GradleDistributionProvider.calculated(GradleDistributionProvider.class, context -> GradleDistributionFactory.wrapper((File)((File)context.getWorkingDirectory().get())));
    }

    public static GradleDistributionProvider fromGradleWrapper(File baseDirectory) {
        return GradleDistributionProvider.fixed(GradleDistributionProvider.class, GradleDistributionFactory.wrapper((File)baseDirectory));
    }

    public static GradleDistributionProvider executorDefault() {
        return GradleDistributionProvider.calculated(GradleDistributionProvider.class, new Function<GradleExecutionContext, GradleDistribution>(){

            @Override
            public GradleDistribution apply(GradleExecutionContext context) {
                if (this.isGradleWrapperExecutor(context.getExecutorType())) {
                    return GradleDistributionFactory.wrapper((File)((File)context.getWorkingDirectory().get()));
                }
                return GradleDistributionProvider.findGradleInstallFromGradleRunner();
            }

            private boolean isGradleWrapperExecutor(Class<? extends GradleExecutor> type) {
                return type.getSimpleName().contains("Wrapper");
            }
        });
    }

    public static GradleDistributionProvider version(final String versionNumber) {
        return GradleDistributionProvider.fixed(GradleDistributionProvider.class, new GradleDistribution(){

            public TestFile getGradleHomeDirectory() {
                return null;
            }

            public TestFile getBinDistribution() {
                return null;
            }

            public GradleVersion getVersion() {
                return GradleVersion.version((String)versionNumber);
            }

            public GradleExecuter executer(TestFile testDirectoryProvider) {
                return null;
            }

            public boolean worksWith(Jvm jvm) {
                return false;
            }

            public boolean worksWith(OperatingSystem os) {
                return false;
            }

            public boolean isDaemonIdleTimeoutConfigurable() {
                return false;
            }

            public boolean isToolingApiSupported() {
                return false;
            }

            public boolean isToolingApiTargetJvmSupported(JavaVersion javaVersion) {
                return false;
            }

            public boolean isToolingApiLoggingInEmbeddedModeSupported() {
                return false;
            }

            public boolean isToolingApiStdinInEmbeddedModeSupported() {
                return false;
            }

            public boolean isToolingApiLocksBuildActionClasses() {
                return false;
            }

            public CacheVersion getArtifactCacheLayoutVersion() {
                return null;
            }

            public boolean wrapperCanExecute(GradleVersion version) {
                return false;
            }

            public boolean isSupportsSpacesInGradleAndJavaOpts() {
                return false;
            }

            public boolean isFullySupportsIvyRepository() {
                return false;
            }

            public boolean isWrapperSupportsGradleUserHomeCommandLineOption() {
                return false;
            }

            public boolean isAddsTaskExecutionExceptionAroundAllTaskFailures() {
                return false;
            }

            public boolean isToolingApiRetainsOriginalFailureOnCancel() {
                return false;
            }

            public boolean isToolingApiHasCauseOnCancel() {
                return false;
            }

            public boolean isToolingApiDoesNotAddCausesOnTaskCancel() {
                return false;
            }

            public boolean isToolingApiHasCauseOnForcedCancel() {
                return false;
            }

            public boolean isToolingApiLogsFailureOnCancel() {
                return false;
            }

            public boolean isToolingApiHasCauseOnPhasedActionFail() {
                return false;
            }

            public boolean isToolingApiMergesStderrIntoStdout() {
                return false;
            }

            public <T> T selectOutputWithFailureLogging(T stdout, T stderr) {
                return null;
            }

            public boolean isToolingApiLogsConfigureSummary() {
                return false;
            }
        });
    }

    public static GradleDistributionProvider installation(File installation) {
        throw new UnsupportedOperationException();
    }

    public static GradleDistributionProvider uri(URI distribution) {
        throw new UnsupportedOperationException();
    }
}

