/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.BuildTask;
import dev.gradleplugins.runnerkit.TaskOutcome;
import dev.gradleplugins.runnerkit.TaskPath;
import java.util.Objects;
import lombok.NonNull;

public final class BuildTaskImpl
implements BuildTask {
    @NonNull
    private final TaskPath path;
    @NonNull
    private final TaskOutcome outcome;
    @NonNull
    private final String output;

    BuildTaskImpl(TaskPath path, TaskOutcome outcome, String output) {
        this.path = path;
        this.outcome = outcome;
        this.output = output;
    }

    public String getPath() {
        return this.path.get();
    }

    public TaskOutcome getOutcome() {
        return this.outcome;
    }

    public String getOutput() {
        return this.output;
    }

    static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "BuildTaskImpl(path=" + this.getPath() + ", outcome=" + this.getOutcome() + ", output=" + this.getOutput() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildTaskImpl)) {
            return false;
        }
        BuildTaskImpl other = (BuildTaskImpl)o;
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        TaskOutcome this$outcome = this.getOutcome();
        TaskOutcome other$outcome = other.getOutcome();
        if (this$outcome == null ? other$outcome != null : !this$outcome.equals(other$outcome)) {
            return false;
        }
        String this$output = this.getOutput();
        String other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !this$output.equals(other$output));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        TaskOutcome $outcome = this.getOutcome();
        result = result * 59 + ($outcome == null ? 43 : $outcome.hashCode());
        String $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        return result;
    }

    static final class Builder {
        private TaskOutcome outcome = TaskOutcome.SUCCESS;
        private TaskPath path;
        private final StringBuilder outputBuilder = new StringBuilder();

        Builder() {
        }

        Builder withOutcome(TaskOutcome outcome) {
            this.outcome = outcome;
            return this;
        }

        Builder withPath(TaskPath path) {
            this.path = path;
            return this;
        }

        Builder appendToOutput(String output) {
            this.outputBuilder.append(output);
            return this;
        }

        BuildTaskImpl build() {
            return new BuildTaskImpl(Objects.requireNonNull(this.path), this.outcome, this.outputBuilder.toString());
        }
    }
}

