/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.BuildResult;
import dev.gradleplugins.runnerkit.BuildTask;
import dev.gradleplugins.runnerkit.BuildTaskImpl;
import dev.gradleplugins.runnerkit.TaskOutcome;
import dev.gradleplugins.runnerkit.TaskPath;
import dev.nokee.core.exec.CommandLineToolLogContent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class BuildResultImpl
implements BuildResult {
    private final Map<TaskPath, BuildTask> executedTaskInOrder;
    private final ActionableTaskCount actionableTaskCount;
    private final CommandLineToolLogContent output;

    BuildResultImpl(Map<TaskPath, BuildTask> executedTaskInOrder, CommandLineToolLogContent output, ActionableTaskCount actionableTaskCount) {
        this.executedTaskInOrder = executedTaskInOrder;
        this.output = output;
        this.actionableTaskCount = actionableTaskCount;
    }

    public static BuildResult from(String output) {
        return BuildResultImpl.from(CommandLineToolLogContent.of((String)output));
    }

    public static BuildResult from(CommandLineToolLogContent output) {
        CommandLineToolLogContent normalizedOutput = BuildResultImpl.normalize(output);
        TaskCollector visitor = new TaskCollector();
        normalizedOutput.visitEachLine((Consumer)new TaskOutputVisitorAdapter(new NewLineAdjuster(visitor)));
        Map<TaskPath, BuildTask> discoveredTasks = visitor.getDiscoveredTasks();
        ActionableTaskCount actionableTaskCount = visitor.getActionableTaskCount().orElseGet(() -> ActionableTaskCount.from(discoveredTasks));
        return new BuildResultImpl(discoveredTasks, normalizedOutput, actionableTaskCount);
    }

    public String getOutput() {
        return this.output.getAsString();
    }

    public List<String> getExecutedTaskPaths() {
        return Collections.unmodifiableList(this.executedTaskInOrder.values().stream().map(BuildResultImpl::toPath).collect(Collectors.toList()));
    }

    public List<String> getSkippedTaskPaths() {
        return Collections.unmodifiableList(this.executedTaskInOrder.values().stream().filter(it -> it.getOutcome().isSkipped()).map(BuildResultImpl::toPath).collect(Collectors.toList()));
    }

    private static String toPath(BuildTask buildTask) {
        return buildTask.getPath();
    }

    public List<BuildTask> getTasks() {
        return Collections.unmodifiableList(new ArrayList<BuildTask>(this.executedTaskInOrder.values()));
    }

    public List<BuildTask> tasks(TaskOutcome outcome) {
        return Collections.unmodifiableList(this.executedTaskInOrder.values().stream().filter(it -> it.getOutcome().equals((Object)outcome)).collect(Collectors.toList()));
    }

    @Nullable
    public BuildTask task(String taskPath) {
        return this.executedTaskInOrder.get(TaskPath.of((String)taskPath));
    }

    public BuildResult withNormalizedTaskOutput(Predicate<TaskPath> predicate, UnaryOperator<String> outputNormalizer) {
        Map<TaskPath, BuildTask> tasks = Collections.unmodifiableMap(this.executedTaskInOrder.entrySet().stream().map(entry -> {
            if (predicate.test((TaskPath)entry.getKey())) {
                return new AbstractMap.SimpleEntry(entry.getKey(), new BuildTaskImpl((TaskPath)entry.getKey(), ((BuildTask)entry.getValue()).getOutcome(), (String)outputNormalizer.apply(((BuildTask)entry.getValue()).getOutput())));
            }
            return entry;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BuildResultImpl.throwingMerger(), LinkedHashMap::new)));
        return new BuildResultImpl(tasks, this.output, this.actionableTaskCount);
    }

    public BuildResult asRichOutputResult() {
        Map<TaskPath, BuildTask> tasks = Collections.unmodifiableMap(this.executedTaskInOrder.entrySet().stream().filter(it -> !((BuildTask)it.getValue()).getOutput().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BuildResultImpl.throwingMerger(), LinkedHashMap::new)));
        return new BuildResultImpl(tasks, this.output, this.actionableTaskCount);
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static CommandLineToolLogContent normalize(CommandLineToolLogContent content) {
        return content.withAnsiControlCharactersInterpreted().withNormalizedEndOfLine().visitEachLine((Consumer)JavaIllegalAccessWarningsStripper.INSTANCE).visitEachLine((Consumer)GradleDaemonMessageStripper.INSTANCE).visitEachLine((Consumer)WarningSummaryMessageStripper.INSTANCE).visitEachLine((Consumer)BuildResultNormalizer.INSTANCE);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildResultImpl)) {
            return false;
        }
        BuildResultImpl other = (BuildResultImpl)o;
        Map<TaskPath, BuildTask> this$executedTaskInOrder = this.executedTaskInOrder;
        Map<TaskPath, BuildTask> other$executedTaskInOrder = other.executedTaskInOrder;
        if (this$executedTaskInOrder == null ? other$executedTaskInOrder != null : !((Object)this$executedTaskInOrder).equals(other$executedTaskInOrder)) {
            return false;
        }
        ActionableTaskCount this$actionableTaskCount = this.actionableTaskCount;
        ActionableTaskCount other$actionableTaskCount = other.actionableTaskCount;
        return !(this$actionableTaskCount == null ? other$actionableTaskCount != null : !((Object)this$actionableTaskCount).equals(other$actionableTaskCount));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TaskPath, BuildTask> $executedTaskInOrder = this.executedTaskInOrder;
        result = result * 59 + ($executedTaskInOrder == null ? 43 : ((Object)$executedTaskInOrder).hashCode());
        ActionableTaskCount $actionableTaskCount = this.actionableTaskCount;
        result = result * 59 + ($actionableTaskCount == null ? 43 : ((Object)$actionableTaskCount).hashCode());
        return result;
    }

    private static final class ActionableTaskCount {
        final long executedTaskCount;
        final long upToDateTaskCount;

        ActionableTaskCount(long executedTaskCount, long upToDateTaskCount) {
            this.executedTaskCount = executedTaskCount;
            this.upToDateTaskCount = upToDateTaskCount;
        }

        public static ActionableTaskCount from(Map<TaskPath, BuildTask> discoveredTasks) {
            return new ActionableTaskCount(discoveredTasks.values().stream().filter(ActionableTaskCount::isExecuted).count(), discoveredTasks.values().stream().filter(ActionableTaskCount::isUpToDate).count());
        }

        private static boolean isExecuted(BuildTask task) {
            return !task.getOutcome().isSkipped();
        }

        private static boolean isUpToDate(BuildTask task) {
            return task.getOutcome().isSkipped();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActionableTaskCount)) {
                return false;
            }
            ActionableTaskCount other = (ActionableTaskCount)o;
            if (this.executedTaskCount != other.executedTaskCount) {
                return false;
            }
            return this.upToDateTaskCount == other.upToDateTaskCount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $executedTaskCount = this.executedTaskCount;
            result = result * 59 + (int)($executedTaskCount >>> 32 ^ $executedTaskCount);
            long $upToDateTaskCount = this.upToDateTaskCount;
            result = result * 59 + (int)($upToDateTaskCount >>> 32 ^ $upToDateTaskCount);
            return result;
        }
    }

    private static enum BuildResultNormalizer implements Consumer<CommandLineToolLogContent.LineDetails>
    {
        INSTANCE;

        private static final Pattern BUILD_RESULT_PATTERN;

        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            if (BUILD_RESULT_PATTERN.matcher(details.getLine()).matches()) {
                details.replaceWith(BUILD_RESULT_PATTERN.matcher(details.getLine()).replaceFirst("BUILD $1"));
            }
        }

        static {
            BUILD_RESULT_PATTERN = Pattern.compile("BUILD (SUCCESSFUL|FAILED) in( \\d+m?[smh])+");
        }
    }

    private static enum WarningSummaryMessageStripper implements Consumer<CommandLineToolLogContent.LineDetails>
    {
        INSTANCE;

        private static final String WARNING_SUMMARY = "Deprecated Gradle features were used in this build, making it incompatible with Gradle";

        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            if (details.getLine().contains(WARNING_SUMMARY)) {
                details.drop(4);
            }
        }
    }

    private static enum GradleDaemonMessageStripper implements Consumer<CommandLineToolLogContent.LineDetails>
    {
        INSTANCE;

        static final String STARTING_DAEMON_MESSAGE = "Starting a Gradle Daemon";
        static final String DAEMON_WILL_STOP_MESSAGE = "Daemon will be stopped at the end of the build ";
        static final String EXPIRE_DAEMON_MESSAGE = "Expiring Daemon because JVM heap space is exhausted";

        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            String line = details.getLine();
            if (line.contains(STARTING_DAEMON_MESSAGE)) {
                details.dropLine();
            } else if (line.contains(DAEMON_WILL_STOP_MESSAGE)) {
                details.dropLine();
            } else if (line.contains(EXPIRE_DAEMON_MESSAGE)) {
                details.dropLine();
            }
        }
    }

    private static enum JavaIllegalAccessWarningsStripper implements Consumer<CommandLineToolLogContent.LineDetails>
    {
        INSTANCE;


        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            if (details.getLine().startsWith("WARNING: An illegal reflective access operation has occurred") || details.getLine().equals("WARNING: All illegal access operations will be denied in a future release")) {
                details.dropLine();
            }
        }
    }

    private static final class TaskOutputVisitorAdapter
    implements Consumer<CommandLineToolLogContent.LineDetails> {
        private static final Pattern TASK_PATTERN = Pattern.compile("(> Task )?(:\\S+)\\s*(SKIPPED|UP-TO-DATE|FROM-CACHE|NO-SOURCE|FAILED)?");
        private static final Pattern ACTIONABLE_TASKS_PATTERN = Pattern.compile("(\\d+) actionable tasks?: (\\d+) executed(, (\\d+) up-to-date)?");
        private final TaskOutputVisitor visitor;

        TaskOutputVisitorAdapter(TaskOutputVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void accept(CommandLineToolLogContent.LineDetails details) {
            Matcher matches = TASK_PATTERN.matcher(details.getLine());
            if (matches.matches()) {
                String taskPath = matches.group(2);
                String taskOutcome = matches.group(3);
                if (taskOutcome == null) {
                    this.visitor.visitTaskHeader(TaskPath.of((String)taskPath));
                } else {
                    this.visitor.visitTaskHeader(TaskPath.of((String)taskPath), TaskOutcome.of((String)taskOutcome));
                }
            } else if (details.getLine().equals("BUILD SUCCESSFUL")) {
                this.visitor.visitBuildResult();
            } else if (details.getLine().equals("BUILD FAILED")) {
                this.visitor.visitBuildResult();
            } else if (ACTIONABLE_TASKS_PATTERN.matcher(details.getLine()).matches()) {
                int upToDateTaskCount;
                Matcher m = ACTIONABLE_TASKS_PATTERN.matcher(details.getLine());
                m.matches();
                int actionableTaskCount = Integer.parseInt(m.group(1));
                int executedTaskCount = Integer.parseInt(m.group(2));
                int n = upToDateTaskCount = m.group(4) != null ? Integer.parseInt(m.group(4)) : 0;
                assert (actionableTaskCount == executedTaskCount + upToDateTaskCount);
                this.visitor.visitActionableTasks(new ActionableTaskCount(executedTaskCount, upToDateTaskCount));
            } else {
                this.visitor.visitContentLine(details.getLine());
            }
        }
    }

    private static final class CurrentTaskAwareVisitor
    implements TaskOutputVisitor {
        private final TaskOutputVisitor delegate;
        private TaskPath currentTask = null;

        CurrentTaskAwareVisitor(TaskOutputVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void visitTaskHeader(TaskPath taskPath) {
            this.currentTask = taskPath;
            this.delegate.visitTaskHeader(taskPath);
        }

        @Override
        public void visitTaskHeader(TaskPath taskPath, TaskOutcome taskOutcome) {
            this.currentTask = taskPath;
            this.delegate.visitTaskHeader(taskPath, taskOutcome);
        }

        @Override
        public void visitTaskOutput(TaskPath taskPath, String line) {
            this.delegate.visitTaskOutput(taskPath, line);
        }

        @Override
        public void visitBuildResult() {
            this.currentTask = null;
            this.delegate.visitBuildResult();
        }

        @Override
        public void visitActionableTasks(ActionableTaskCount actionableTaskCount) {
            this.delegate.visitActionableTasks(actionableTaskCount);
        }

        @Override
        public void visitContentLine(String line) {
            if (this.currentTask != null) {
                this.delegate.visitTaskOutput(this.currentTask, line);
            } else {
                this.delegate.visitContentLine(line);
            }
        }
    }

    private static final class NewLineAdjuster
    implements TaskOutputVisitor {
        private final TaskOutputVisitor delegate;
        private TaskPath currentTask = null;
        private String previousLine = null;
        private boolean hasNoOutputSinceHeader = true;

        NewLineAdjuster(TaskOutputVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void visitTaskHeader(TaskPath taskPath) {
            if (this.previousLine != null) {
                if (this.previousLine.isEmpty()) {
                    if (!this.hasNoOutputSinceHeader) {
                        this.delegate.visitTaskOutput(this.currentTask, "\n");
                    }
                } else {
                    this.delegate.visitTaskOutput(this.currentTask, this.previousLine);
                }
                this.previousLine = null;
            }
            this.currentTask = taskPath;
            this.hasNoOutputSinceHeader = true;
            this.delegate.visitTaskHeader(taskPath);
        }

        @Override
        public void visitTaskHeader(TaskPath taskPath, TaskOutcome taskOutcome) {
            if (this.previousLine != null) {
                if (this.previousLine.isEmpty()) {
                    if (!this.hasNoOutputSinceHeader) {
                        this.delegate.visitTaskOutput(this.currentTask, "\n");
                    }
                } else {
                    this.delegate.visitTaskOutput(this.currentTask, this.previousLine);
                }
                this.previousLine = null;
            }
            this.currentTask = taskPath;
            this.hasNoOutputSinceHeader = true;
            this.delegate.visitTaskHeader(taskPath, taskOutcome);
        }

        @Override
        public void visitTaskOutput(TaskPath taskPath, String line) {
            this.hasNoOutputSinceHeader = false;
            this.delegate.visitTaskOutput(taskPath, line);
        }

        @Override
        public void visitBuildResult() {
            if (this.previousLine != null) {
                if (this.previousLine.isEmpty()) {
                    if (!this.hasNoOutputSinceHeader) {
                        this.delegate.visitTaskOutput(this.currentTask, "\n");
                    }
                } else {
                    this.delegate.visitTaskOutput(this.currentTask, this.previousLine);
                }
                this.previousLine = null;
            }
            this.currentTask = null;
            this.hasNoOutputSinceHeader = false;
            this.delegate.visitBuildResult();
        }

        @Override
        public void visitActionableTasks(ActionableTaskCount actionableTaskCount) {
            this.delegate.visitActionableTasks(actionableTaskCount);
        }

        @Override
        public void visitContentLine(String line) {
            if (this.previousLine != null) {
                this.delegate.visitTaskOutput(this.currentTask, this.previousLine + "\n");
                this.previousLine = null;
            }
            if (this.currentTask != null) {
                this.previousLine = line;
            } else {
                this.delegate.visitContentLine(line);
            }
        }
    }

    private static final class TaskCollector
    implements TaskOutputVisitor {
        private final Map<TaskPath, BuildTaskImpl.Builder> discoveredTasks = new LinkedHashMap<TaskPath, BuildTaskImpl.Builder>();
        private ActionableTaskCount actionableTaskCount = null;

        private TaskCollector() {
        }

        Optional<ActionableTaskCount> getActionableTaskCount() {
            return Optional.ofNullable(this.actionableTaskCount);
        }

        Map<TaskPath, BuildTask> getDiscoveredTasks() {
            return Collections.unmodifiableMap(this.discoveredTasks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((BuildTaskImpl.Builder)it.getValue()).build(), BuildResultImpl.throwingMerger(), LinkedHashMap::new)));
        }

        @Override
        public void visitTaskHeader(TaskPath taskPath) {
            this.discoveredTasks.computeIfAbsent(taskPath, this::newTaskBuilder);
        }

        private BuildTaskImpl.Builder newTaskBuilder(TaskPath taskPath) {
            return BuildTaskImpl.builder().withPath(taskPath);
        }

        @Override
        public void visitTaskHeader(TaskPath taskPath, TaskOutcome taskOutcome) {
            this.discoveredTasks.compute(taskPath, this.updateOutcome(taskOutcome));
        }

        private BiFunction<TaskPath, BuildTaskImpl.Builder, BuildTaskImpl.Builder> updateOutcome(TaskOutcome taskOutcome) {
            return (taskPath, buildTask) -> {
                if (buildTask == null) {
                    return BuildTaskImpl.builder().withPath((TaskPath)taskPath).withOutcome(taskOutcome);
                }
                return buildTask.withOutcome(taskOutcome);
            };
        }

        @Override
        public void visitTaskOutput(TaskPath taskPath, String line) {
            this.discoveredTasks.compute(taskPath, this.appendContent(line));
        }

        @Override
        public void visitBuildResult() {
        }

        @Override
        public void visitActionableTasks(ActionableTaskCount actionableTaskCount) {
            this.actionableTaskCount = actionableTaskCount;
        }

        @Override
        public void visitContentLine(String line) {
        }

        private BiFunction<TaskPath, BuildTaskImpl.Builder, BuildTaskImpl.Builder> appendContent(String line) {
            return (taskPath, buildTask) -> {
                assert (buildTask != null);
                return buildTask.appendToOutput(line);
            };
        }
    }

    private static interface TaskOutputVisitor {
        public void visitTaskHeader(TaskPath var1);

        public void visitTaskHeader(TaskPath var1, TaskOutcome var2);

        public void visitTaskOutput(TaskPath var1, String var2);

        public void visitBuildResult();

        public void visitActionableTasks(ActionableTaskCount var1);

        public void visitContentLine(String var1);
    }
}

