/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionJvmSystemPropertyProvider;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class UserHomeDirectoryProvider
extends AbstractGradleExecutionProvider<File>
implements GradleExecutionJvmSystemPropertyProvider {
    public static UserHomeDirectoryProvider implicit() {
        return UserHomeDirectoryProvider.noValue(UserHomeDirectoryProvider.class);
    }

    public static UserHomeDirectoryProvider of(File userHomeDirectory) {
        return UserHomeDirectoryProvider.fixed(UserHomeDirectoryProvider.class, userHomeDirectory);
    }

    @Override
    public Map<String, String> getAsJvmSystemProperties() {
        return this.map(UserHomeDirectoryProvider::asJvmSystemProperties).orElseGet(Collections::emptyMap);
    }

    private static Map<String, String> asJvmSystemProperties(File userHomeDirectory) {
        return Collections.singletonMap("user.home", userHomeDirectory.getAbsolutePath());
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((List)context.getArguments().get()).stream().anyMatch(it -> it.startsWith("-Duser.home"))) {
            throw new InvalidRunnerConfigurationException("Please use GradleRunner#withUserHomeDirectory(File) instead of using the command line flags.");
        }
    }
}

