/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit.providers;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.providers.AbstractGradleExecutionProvider;
import dev.gradleplugins.runnerkit.providers.GradleExecutionCommandLineProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class InitScriptsProvider
extends AbstractGradleExecutionProvider<List<File>>
implements GradleExecutionCommandLineProvider {
    public InitScriptsProvider plus(File initScript) {
        ArrayList<File> result = new ArrayList<File>();
        result.addAll((Collection)this.get());
        result.add(initScript);
        return InitScriptsProvider.fixed(InitScriptsProvider.class, Collections.unmodifiableList(result));
    }

    public static InitScriptsProvider empty() {
        return InitScriptsProvider.fixed(InitScriptsProvider.class, Collections.emptyList());
    }

    @Override
    public List<String> getAsArguments() {
        return this.map(InitScriptsProvider::asArguments).orElseGet(Collections::emptyList);
    }

    private static List<String> asArguments(List<File> initScripts) {
        return initScripts.stream().map(File::getAbsolutePath).flatMap(InitScriptsProvider::withFlag).collect(Collectors.toList());
    }

    private static Stream<String> withFlag(String initScriptPath) {
        return Stream.of("--init-script", initScriptPath);
    }

    @Override
    public void validate(GradleExecutionContext context) {
        if (((List)context.getArguments().get()).stream().anyMatch(it -> it.startsWith("--init-script") || it.equals("-I"))) {
            throw new InvalidRunnerConfigurationException("Please use GradleRunner#usingInitScript(File) instead of using the command line flags.");
        }
    }
}

