/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutionResult;
import dev.gradleplugins.runnerkit.GradleExecutor;
import dev.gradleplugins.runnerkit.GradleRunnerParameters;
import dev.gradleplugins.runnerkit.providers.BeforeExecute;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractGradleExecutor
implements GradleExecutor {
    AbstractGradleExecutor() {
    }

    public final GradleExecutionResult run(GradleExecutionContext parameters) {
        return this.doRun(this.fireBeforeExecute(parameters));
    }

    private GradleExecutionContext fireBeforeExecute(GradleExecutionContext parameters) {
        GradleRunnerParameters.allExecutionParameters(parameters).stream().filter(it -> it instanceof BeforeExecute).forEach(action -> ((BeforeExecute)action).accept(parameters));
        return parameters;
    }

    protected abstract GradleExecutionResult doRun(GradleExecutionContext var1);

    protected static List<String> getImplicitBuildJvmArgs() {
        ArrayList<String> buildJvmOpts = new ArrayList<String>();
        buildJvmOpts.add("-ea");
        buildJvmOpts.add("-Xms256m");
        buildJvmOpts.add("-Xmx1024m");
        buildJvmOpts.add("-XX:MaxMetaspaceSize=512m");
        buildJvmOpts.add("-XX:+HeapDumpOnOutOfMemoryError");
        return buildJvmOpts;
    }
}

