/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class ClassUtils {
    ClassUtils() {
    }

    public static <T> T staticInvoke(String className, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod(methodName, parameterTypes);
            return (T)method.invoke(null, args);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Please verify your dependencies on runnerKit.", e);
        }
    }

    public static <T> T newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Please verify your dependencies on runnerKit.", e);
        }
    }

    public static <T> T newInstance(String className, Class<?>[] parameterTypes, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            return (T)constructor.newInstance(args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Please verify your dependencies on runnerKit.", e);
        }
    }
}

