/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import dev.gradleplugins.runnerkit.BuildResult;
import dev.gradleplugins.runnerkit.ClassUtils;
import dev.gradleplugins.runnerkit.GradleExecutionContext;
import dev.gradleplugins.runnerkit.GradleExecutor;
import dev.gradleplugins.runnerkit.InvalidPluginMetadataException;
import dev.gradleplugins.runnerkit.InvalidRunnerConfigurationException;
import dev.gradleplugins.runnerkit.UnexpectedBuildFailure;
import dev.gradleplugins.runnerkit.UnexpectedBuildSuccess;
import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public interface GradleRunner {
    public static GradleRunner create(GradleExecutor executor) {
        return (GradleRunner)ClassUtils.newInstance("dev.gradleplugins.runnerkit.GradleRunnerImpl", new Class[]{GradleExecutor.class}, executor);
    }

    public GradleRunner withGradleVersion(String var1);

    public GradleRunner withGradleInstallation(File var1);

    public GradleRunner withGradleDistribution(URI var1);

    public List<? extends File> getPluginClasspath();

    public GradleRunner withPluginClasspath() throws InvalidPluginMetadataException;

    public GradleRunner withPluginClasspath(Iterable<? extends File> var1);

    public GradleRunner inDirectory(File var1);

    public File getWorkingDirectory() throws InvalidRunnerConfigurationException;

    public GradleRunner withStacktraceDisabled();

    public GradleRunner withBuildCacheEnabled();

    default public GradleRunner withTasks(String ... tasks) {
        return this.withTasks(Arrays.asList(tasks));
    }

    public GradleRunner withTasks(List<String> var1);

    default public GradleRunner withArguments(String ... args) {
        return this.withArguments(Arrays.asList(args));
    }

    public GradleRunner withArguments(List<String> var1);

    public GradleRunner withArgument(String var1);

    public List<String> getAllArguments();

    public GradleRunner usingSettingsFile(File var1);

    public GradleRunner ignoresMissingSettingsFile();

    public GradleRunner usingBuildScript(File var1);

    public GradleRunner usingInitScript(File var1);

    public GradleRunner usingProjectDirectory(File var1);

    public GradleRunner withoutDeprecationChecks();

    public GradleRunner withDefaultCharacterEncoding(Charset var1);

    public GradleRunner withDefaultLocale(Locale var1);

    public GradleRunner withWelcomeMessageEnabled();

    public GradleRunner publishBuildScans();

    public GradleRunner withUserHomeDirectory(File var1);

    public GradleRunner withGradleUserHomeDirectory(File var1);

    public GradleRunner requireOwnGradleUserHomeDirectory();

    public GradleRunner withEnvironmentVariables(Map<String, ?> var1);

    public GradleRunner withEnvironmentVariable(String var1, String var2);

    @Deprecated
    public GradleRunner withEnvironmentVars(Map<String, ?> var1);

    default public GradleRunner withEnvironment(Map<String, String> environmentVariables) {
        return this.withEnvironmentVariables(environmentVariables);
    }

    public GradleRunner withRichConsoleEnabled();

    public GradleRunner configure(UnaryOperator<GradleRunner> var1);

    public GradleRunner forwardStandardOutput(Writer var1);

    default public GradleRunner forwardStdOutput(Writer writer) {
        return this.forwardStandardOutput(writer);
    }

    public GradleRunner forwardStandardError(Writer var1);

    default public GradleRunner forwardStdError(Writer writer) {
        return this.forwardStandardError(writer);
    }

    public GradleRunner forwardOutput();

    public GradleRunner beforeExecute(UnaryOperator<GradleRunner> var1);

    public GradleRunner afterExecute(Consumer<GradleExecutionContext> var1);

    public BuildResult build() throws InvalidRunnerConfigurationException, UnexpectedBuildFailure;

    public BuildResult buildAndFail() throws InvalidRunnerConfigurationException, UnexpectedBuildSuccess;
}

