/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.runnerkit;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public enum TaskOutcome {
    SUCCESS(false, null),
    FAILED(true, "FAILED"),
    UP_TO_DATE(true, "UP-TO-DATE"),
    SKIPPED(true, "SKIPPED"),
    FROM_CACHE(true, "FROM-CACHE"),
    NO_SOURCE(true, "NO-SOURCE");

    private final boolean skipped;
    @Nullable
    private final String message;

    private TaskOutcome(boolean skipped, String message) {
        this.skipped = skipped;
        this.message = message;
    }

    boolean isSkipped() {
        return this.skipped;
    }

    static TaskOutcome of(@Nullable String value) {
        return Arrays.stream(TaskOutcome.values()).filter(it -> Objects.equals(it.message, value)).findFirst().orElseThrow(RuntimeException::new);
    }
}

