/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.util;

import groovy.lang.Closure;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.util.GradleVersion;

public final class ClosureWrappedConfigureAction<T>
implements Action<T> {
    private final Closure configureClosure;

    public ClosureWrappedConfigureAction(Closure configureClosure) {
        this.configureClosure = Objects.requireNonNull(configureClosure);
    }

    public void execute(T t) {
        try {
            Class<?> ConfigureUtil = ClosureWrappedConfigureAction.findConfigureUtilClass();
            Method configure = ConfigureUtil.getMethod("configure", Closure.class, Object.class);
            configure.invoke(null, this.configureClosure, t);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> findConfigureUtilClass() throws ClassNotFoundException {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) > 0) {
            return Class.forName("org.gradle.util.internal.ConfigureUtil");
        }
        return Class.forName("org.gradle.util.ConfigureUtil");
    }

    public Closure getConfigureClosure() {
        return this.configureClosure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClosureWrappedConfigureAction that = (ClosureWrappedConfigureAction)o;
        return Objects.equals(this.configureClosure, that.configureClosure);
    }

    public int hashCode() {
        return Objects.hash(this.configureClosure);
    }
}

