/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.rules;

import dev.gradleplugins.GradlePluginDevelopmentDependencyExtension;
import dev.gradleplugins.internal.DependencyFactory;
import dev.gradleplugins.internal.runtime.dsl.GroovyHelper;
import dev.gradleplugins.internal.util.LocalOrRemoteVersionTransformer;
import groovy.lang.Closure;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;

abstract class ProjectDependenciesExtensionRule
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(ProjectDependenciesExtensionRule.class);

    @Inject
    public ProjectDependenciesExtensionRule() {
    }

    public void apply(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        DefaultGradlePluginDevelopmentDependencyExtension extension = new DefaultGradlePluginDevelopmentDependencyExtension(dependencies);
        dependencies.getExtensions().add("gradlePluginDevelopment", (Object)extension);
        GroovyHelper.instance().addNewInstanceMethod(dependencies, "gradleApi", (Closure)new MethodClosure((Object)extension, "gradleApi"));
        GroovyHelper.instance().addNewInstanceMethod(dependencies, "gradleTestKit", (Closure)new MethodClosure((Object)extension, "gradleTestKit"));
        GroovyHelper.instance().addNewInstanceMethod(dependencies, "gradleFixtures", (Closure)new MethodClosure((Object)extension, "gradleFixtures"));
        GroovyHelper.instance().addNewInstanceMethod(dependencies, "gradleRunnerKit", (Closure)new MethodClosure((Object)extension, "gradleRunnerKit"));
        GroovyHelper.instance().addNewInstanceMethod(dependencies, "gradlePlugin", (Closure)new MethodClosure((Object)extension, "gradlePlugin"));
    }

    private static final class DefaultGradlePluginDevelopmentDependencyExtension
    implements GradlePluginDevelopmentDependencyExtension,
    HasPublicType {
        private final DependencyFactory factory;
        private final Transformer<Dependency, String> gradleApiTransformer;
        private final Transformer<Dependency, String> gradleTestKitTransformer;

        @Inject
        public DefaultGradlePluginDevelopmentDependencyExtension(DependencyHandler dependencies) {
            this.factory = new DependencyFactory(dependencies);
            this.gradleApiTransformer = new LocalOrRemoteVersionTransformer<Dependency>(this.factory::localGradleApi, this.factory::gradleApi);
            this.gradleTestKitTransformer = new LocalOrRemoteVersionTransformer<Dependency>(this.factory::localGradleTestKit, this.factory::gradleTestKit);
        }

        @Override
        public Dependency gradleApi(String version) {
            return (Dependency)this.gradleApiTransformer.transform((Object)version);
        }

        @Override
        public Dependency gradleTestKit(String version) {
            return (Dependency)this.gradleTestKitTransformer.transform((Object)version);
        }

        @Override
        public Dependency gradleFixtures() {
            return this.factory.gradleFixtures();
        }

        @Override
        public Dependency gradleRunnerKit() {
            return this.factory.gradleRunnerKit();
        }

        @Override
        public ExternalModuleDependency gradlePlugin(String pluginNotation) {
            return this.factory.gradlePlugin(pluginNotation);
        }

        public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(GradlePluginDevelopmentDependencyExtension.class);
        }
    }
}

