/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradleRuntimeCompatibility;
import dev.gradleplugins.GroovyGradlePluginDevelopmentExtension;
import dev.gradleplugins.internal.DeferredRepositoryFactory;
import dev.gradleplugins.internal.DependencyBucketFactory;
import dev.gradleplugins.internal.DependencyFactory;
import dev.gradleplugins.internal.GradlePluginDevelopmentExtensionInternal;
import dev.gradleplugins.internal.plugins.AbstractGradlePluginDevelopmentPlugin;
import dev.gradleplugins.internal.util.GradlePluginDevelopmentUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.GradleVersion;

public class GroovyGradlePluginDevelopmentPlugin
implements Plugin<Project> {
    private static final String PLUGIN_ID = "dev.gradleplugins.groovy-gradle-plugin";

    public void apply(Project project) {
        AbstractGradlePluginDevelopmentPlugin.assertOtherGradlePluginDevelopmentPluginsAreNeverApplied(project.getPluginManager(), PLUGIN_ID);
        AbstractGradlePluginDevelopmentPlugin.assertJavaGradlePluginIsNotPreviouslyApplied(project.getPluginManager(), PLUGIN_ID);
        AbstractGradlePluginDevelopmentPlugin.assertKotlinDslPluginIsNeverApplied(project.getPluginManager(), PLUGIN_ID);
        project.getPluginManager().apply("dev.gradleplugins.gradle-plugin-base");
        project.getPluginManager().apply("dev.gradleplugins.gradle-plugin-testing-base");
        project.getPluginManager().apply(GroovyGradlePluginDevelopmentPlugin.coreGradlePluginId());
        project.getPluginManager().apply("groovy");
        GradlePluginDevelopmentExtensionInternal groovy = AbstractGradlePluginDevelopmentPlugin.registerLanguageExtension(project, "groovy", GroovyGradlePluginDevelopmentExtension.class);
        Provider extension = project.provider(() -> GradlePluginDevelopmentCompatibilityExtension.compatibility(GradlePluginDevelopmentUtils.gradlePlugin(project)));
        groovy.getGroovyVersion().convention(extension.flatMap(it -> it.getMinimumGradleVersion().map(GradleRuntimeCompatibility::groovyVersionOf)));
        DependencyFactory factory = new DependencyFactory(project.getDependencies());
        new DependencyBucketFactory(project, (Provider<SourceSet>)project.provider(() -> GradlePluginDevelopmentUtils.gradlePlugin(project).getPluginSourceSet())).create("compileOnly").add(groovy.getGroovyVersion().map(factory::groovy));
        DeferredRepositoryFactory repositoryFactory = (DeferredRepositoryFactory)project.getObjects().newInstance(DeferredRepositoryFactory.class, new Object[]{project});
        repositoryFactory.groovy();
    }

    private static String coreGradlePluginId() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            return "groovy-gradle-plugin";
        }
        return "java-gradle-plugin";
    }
}

