/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradlePluginDevelopmentTestSuite;
import dev.gradleplugins.internal.DependencyBucketFactory;
import dev.gradleplugins.internal.DependencyFactory;
import dev.gradleplugins.internal.plugins.GradlePluginDevelopmentTestSuiteRegistrationAction;
import dev.gradleplugins.internal.util.GradlePluginDevelopmentUtils;
import dev.gradleplugins.internal.util.LocalOrRemoteVersionTransformer;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public abstract class GradlePluginDevelopmentUnitTestingPlugin
implements Plugin<Project> {
    private static final String TEST_NAME = "test";
    private static final GradlePluginDevelopmentTestSuiteRegistrationAction TEST_RULE = new GradlePluginDevelopmentTestSuiteRegistrationAction("test");

    public static GradlePluginDevelopmentTestSuite test(Project project) {
        return (GradlePluginDevelopmentTestSuite)project.getExtensions().getByName(TEST_NAME);
    }

    public void apply(Project project) {
        project.getPluginManager().apply("java");
        project.getPluginManager().apply("dev.gradleplugins.gradle-plugin-testing-base");
        TEST_RULE.execute(project);
        project.getPluginManager().withPlugin("java-gradle-plugin", ignored -> project.getPluginManager().withPlugin("dev.gradleplugins.gradle-plugin-base", GradlePluginDevelopmentUnitTestingPlugin.useGradleApiImplementationDependency(project)));
    }

    private static Action<AppliedPlugin> useGradleApiImplementationDependency(Project project) {
        return ignored -> {
            DependencyFactory factory = new DependencyFactory(project.getDependencies());
            new DependencyBucketFactory(project, (Provider<SourceSet>)GradlePluginDevelopmentUnitTestingPlugin.test(project).getSourceSet()).create("implementation").add(project.provider(() -> GradlePluginDevelopmentCompatibilityExtension.compatibility(GradlePluginDevelopmentUtils.gradlePlugin(project))).flatMap(it -> it.getGradleApiVersion().orElse((Object)"local").map(GradlePluginDevelopmentUnitTestingPlugin.localOrRemoteGradleApi(factory))));
        };
    }

    private static Transformer<Dependency, String> localOrRemoteGradleApi(DependencyFactory factory) {
        return new LocalOrRemoteVersionTransformer<Dependency>(factory::localGradleApi, factory::gradleApi);
    }
}

