/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class JvmCompatibilities {
    public abstract Property<JavaVersion> getSourceCompatibility();

    public abstract Property<JavaVersion> getTargetCompatibility();

    private static Provider<JavaVersion> javaToolchainLanguageVersion(Project project) {
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        try {
            Method JavaPluginExtension__getToolchain = java.getClass().getDeclaredMethod("getToolchain", new Class[0]);
            Object toolchain = JavaPluginExtension__getToolchain.invoke((Object)java, new Object[0]);
            Method JavaToolchainSpec__getLanguageVersion = toolchain.getClass().getDeclaredMethod("getLanguageVersion", new Class[0]);
            Provider languageVersion = (Provider)JavaToolchainSpec__getLanguageVersion.invoke(toolchain, new Object[0]);
            return languageVersion.map(Object::toString).map(JavaVersion::toVersion);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return project.provider(() -> null);
        }
    }

    private static <T> Provider<? extends Iterable<T>> asList(Provider<T> provider) {
        return provider.map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private static <T> Provider<T> firstDefined(Project project, Action<? super ListProperty<T>> action) {
        ListProperty versions = project.getObjects().listProperty(Object.class);
        versions.finalizeValueOnRead();
        action.execute((Object)versions);
        return versions.map(it -> {
            Iterator iter = it.iterator();
            if (!iter.hasNext()) {
                return null;
            }
            return iter.next();
        });
    }

    private static <T> Callable<T> disconnect(final Provider<T> provider) {
        return new Callable<T>(){
            private T value;
            private boolean memoized = false;

            @Override
            public T call() throws Exception {
                if (!this.memoized) {
                    this.value = provider.getOrNull();
                    this.memoized = true;
                }
                return this.value;
            }
        };
    }

    static abstract class DefaultSourceSetJvmCompatibilities
    extends ForSourceSetExtension.SourceSetJvmCompatibilities
    implements Named {
        private final SourceSet sourceSet;

        @Inject
        public DefaultSourceSetJvmCompatibilities(SourceSet sourceSet) {
            this.sourceSet = sourceSet;
        }

        public String getName() {
            return this.sourceSet.getName();
        }

        @Override
        public SourceSet getSourceSet() {
            return this.sourceSet;
        }
    }

    static abstract class SourceSetJvmCompatibilitiesExtension
    implements ForSourceSetExtension {
        private final ObjectFactory objects;
        private final NamedDomainObjectSet<ForSourceSetExtension.SourceSetJvmCompatibilities> compatibilities;

        @Inject
        public SourceSetJvmCompatibilitiesExtension(ObjectFactory objects) {
            this.objects = objects;
            this.compatibilities = objects.namedDomainObjectSet(ForSourceSetExtension.SourceSetJvmCompatibilities.class);
        }

        @Override
        public NamedDomainObjectProvider<ForSourceSetExtension.SourceSetJvmCompatibilities> forSourceSet(SourceSet sourceSet) {
            if (this.compatibilities.findByName(sourceSet.getName()) == null) {
                this.compatibilities.add((Object)((ForSourceSetExtension.SourceSetJvmCompatibilities)this.objects.newInstance(DefaultSourceSetJvmCompatibilities.class, new Object[]{sourceSet})));
            }
            return this.compatibilities.named(sourceSet.getName());
        }

        @Override
        public void configureEach(Action<? super ForSourceSetExtension.SourceSetJvmCompatibilities> action) {
            this.compatibilities.configureEach(action);
        }
    }

    public static interface ForSourceSetExtension {
        public NamedDomainObjectProvider<SourceSetJvmCompatibilities> forSourceSet(SourceSet var1);

        public void configureEach(Action<? super SourceSetJvmCompatibilities> var1);

        public static abstract class SourceSetJvmCompatibilities
        extends JvmCompatibilities {
            public abstract SourceSet getSourceSet();
        }
    }

    static abstract class Rule
    implements Plugin<Project> {
        @Inject
        public Rule() {
        }

        public void apply(Project project) {
            ProjectJvmCompatibilitiesExtension jvmCompatibilities = (ProjectJvmCompatibilitiesExtension)project.getExtensions().create("$jvmProjectCompatibilities", ProjectJvmCompatibilitiesExtension.class, new Object[]{project});
            SourceSetJvmCompatibilitiesExtension extension = (SourceSetJvmCompatibilitiesExtension)project.getExtensions().create("$jvmCompatibilities", SourceSetJvmCompatibilitiesExtension.class, new Object[0]);
            extension.configureEach((Action<? super ForSourceSetExtension.SourceSetJvmCompatibilities>)((Action)it -> {
                it.getSourceCompatibility().convention(JvmCompatibilities.javaToolchainLanguageVersion(project).orElse(jvmCompatibilities.getSourceCompatibility()));
                it.getTargetCompatibility().convention(JvmCompatibilities.javaToolchainLanguageVersion(project).orElse(jvmCompatibilities.getTargetCompatibility()).orElse(it.getSourceCompatibility()));
            }));
            extension.configureEach((Action<? super ForSourceSetExtension.SourceSetJvmCompatibilities>)((Action)it -> project.getTasks().named(it.getSourceSet().getCompileJavaTaskName(), JavaCompile.class).configure(task -> {
                task.getConventionMapping().map("sourceCompatibility", () -> ((JavaVersion)it.getSourceCompatibility().getOrElse((Object)JavaVersion.current())).toString());
                task.getConventionMapping().map("targetCompatibility", () -> ((JavaVersion)it.getTargetCompatibility().getOrElse((Object)JavaVersion.current())).toString());
            })));
        }
    }

    static abstract class ProjectJvmCompatibilitiesExtension
    extends ForProjectExtension {
        @Inject
        public ProjectJvmCompatibilitiesExtension(Project project) {
            JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            this.getTargetCompatibility().convention(JvmCompatibilities.firstDefined(project, versions -> {
                versions.addAll(JvmCompatibilities.asList(JvmCompatibilities.javaToolchainLanguageVersion(project)));
                versions.addAll(JvmCompatibilities.asList(project.provider(JvmCompatibilities.disconnect(project.provider(() -> ((JavaPluginExtension)java).getTargetCompatibility()).map(this.toFinalValue(() -> ((JavaPluginExtension)java).getTargetCompatibility(), arg_0 -> ((JavaPluginExtension)java).setTargetCompatibility(arg_0), (Action<? super JavaVersion>)((Action)it -> {
                    JavaVersion sourceCompatibility = java.getSourceCompatibility();
                    if (!sourceCompatibility.equals((Object)JavaVersion.VERSION_1_1)) {
                        java.setTargetCompatibility(sourceCompatibility);
                    } else if (JvmCompatibilities.javaToolchainLanguageVersion(project).isPresent()) {
                        java.setTargetCompatibility(null);
                    } else {
                        java.setTargetCompatibility(it);
                    }
                })))))));
            }).orElse(this.getSourceCompatibility()));
            this.getTargetCompatibility().finalizeValueOnRead();
            this.getTargetCompatibility().disallowChanges();
            project.afterEvaluate(__ -> this.getTargetCompatibility().finalizeValue());
            this.getSourceCompatibility().convention(JvmCompatibilities.firstDefined(project, versions -> {
                versions.addAll(JvmCompatibilities.asList(JvmCompatibilities.javaToolchainLanguageVersion(project)));
                versions.addAll(JvmCompatibilities.asList(project.provider(JvmCompatibilities.disconnect(project.provider(() -> ((JavaPluginExtension)java).getSourceCompatibility()).map(this.toFinalValue(() -> ((JavaPluginExtension)java).getSourceCompatibility(), arg_0 -> ((JavaPluginExtension)java).setSourceCompatibility(arg_0), (Action<? super JavaVersion>)((Action)it -> java.setSourceCompatibility(it))))))));
            }));
            this.getSourceCompatibility().finalizeValueOnRead();
            this.getSourceCompatibility().disallowChanges();
            project.afterEvaluate(__ -> this.getSourceCompatibility().finalizeValue());
        }

        private Transformer<JavaVersion, JavaVersion> toFinalValue(Supplier<JavaVersion> getter, Consumer<JavaVersion> setter, Action<? super JavaVersion> restoreAction) {
            JavaVersion originalValue = getter.get();
            setter.accept(JavaVersion.VERSION_1_1);
            return it -> {
                if (it.equals((Object)JavaVersion.VERSION_1_1)) {
                    restoreAction.execute((Object)originalValue);
                    return null;
                }
                return it;
            };
        }
    }

    public static abstract class ForProjectExtension
    extends JvmCompatibilities {
    }
}

