/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.GradlePluginDevelopmentDependencyBucket;
import dev.gradleplugins.GradlePluginDevelopmentDependencyModifiers;
import dev.gradleplugins.GradlePluginDevelopmentTestSuite;
import dev.gradleplugins.GradlePluginDevelopmentTestSuiteDependencies;
import dev.gradleplugins.GradlePluginTestingStrategyFactory;
import dev.gradleplugins.GradleRuntimeCompatibility;
import dev.gradleplugins.TaskView;
import dev.gradleplugins.internal.AttachTestTasksToCheckTaskIfPresent;
import dev.gradleplugins.internal.CreateTestTasksFromTestingStrategiesRule;
import dev.gradleplugins.internal.DependencyBucketFactory;
import dev.gradleplugins.internal.DependencyFactory;
import dev.gradleplugins.internal.EnforcedPlatformDependencyModifier;
import dev.gradleplugins.internal.FinalizableComponent;
import dev.gradleplugins.internal.FinalizeTestSuiteProperties;
import dev.gradleplugins.internal.GradlePluginTestingStrategyFactoryInternal;
import dev.gradleplugins.internal.PlatformDependencyModifier;
import dev.gradleplugins.internal.PluginUnderTestMetadataConfigurationSupplier;
import dev.gradleplugins.internal.ReleasedVersionDistributions;
import dev.gradleplugins.internal.TestFixturesDependencyModifier;
import dev.gradleplugins.internal.TestSuiteSourceSetExtendsFromTestedSourceSetIfPresentRule;
import dev.gradleplugins.internal.runtime.dsl.GroovyHelper;
import dev.gradleplugins.internal.util.LocalOrRemoteVersionTransformer;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugin.devel.tasks.PluginUnderTestMetadata;
import org.gradle.util.GradleVersion;

public abstract class GradlePluginDevelopmentTestSuiteInternal
implements GradlePluginDevelopmentTestSuite,
SoftwareComponent,
HasPublicType,
FinalizableComponent {
    private static final String PLUGIN_UNDER_TEST_METADATA_TASK_NAME_PREFIX = "pluginUnderTestMetadata";
    private static final String PLUGIN_DEVELOPMENT_GROUP = "Plugin development";
    private static final String PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION_FORMAT = "Generates the metadata for plugin %s.";
    private final GradlePluginTestingStrategyFactory strategyFactory;
    private final Dependencies dependencies;
    private final String name;
    private final List<Action<? super Test>> testTaskActions = new ArrayList<Action<? super Test>>();
    private final List<Action<? super GradlePluginDevelopmentTestSuite>> finalizeActions = new ArrayList<Action<? super GradlePluginDevelopmentTestSuite>>();
    private final TestTaskView testTasks;
    private final TaskProvider<PluginUnderTestMetadata> pluginUnderTestMetadataTask;
    private final String displayName;
    private boolean finalized = false;

    @Inject
    public GradlePluginDevelopmentTestSuiteInternal(String name, Project project, TaskContainer tasks, ObjectFactory objects, PluginManager pluginManager, ProviderFactory providers, Provider<String> minimumGradleVersion, ReleasedVersionDistributions releasedVersions) {
        this.strategyFactory = new GradlePluginTestingStrategyFactoryInternal(minimumGradleVersion, releasedVersions);
        this.name = name;
        this.displayName = GUtil.toWords(name) + "s";
        this.dependencies = (Dependencies)objects.newInstance(Dependencies.class, new Object[]{project, minimumGradleVersion.orElse((Object)GradleVersion.current().getVersion()).map(GradleRuntimeCompatibility::groovyVersionOf), this});
        this.dependencies.forEach(dependencyBucket -> GroovyHelper.instance().addNewInstanceMethod(this.dependencies, dependencyBucket.getName(), (Closure)new MethodClosure(dependencyBucket, "add")));
        GroovyHelper.instance().addNewInstanceMethod(this.dependencies, "platform", (Closure)new MethodClosure((Object)this.dependencies.getPlatform(), "modify"));
        GroovyHelper.instance().addNewInstanceMethod(this.dependencies, "enforcedPlatform", (Closure)new MethodClosure((Object)this.dependencies.getEnforcedPlatform(), "modify"));
        GroovyHelper.instance().addNewInstanceMethod(this.dependencies, "testFixtures", (Closure)new MethodClosure((Object)this.dependencies.getTestFixtures(), "modify"));
        this.pluginUnderTestMetadataTask = GradlePluginDevelopmentTestSuiteInternal.registerPluginUnderTestMetadataTask(tasks, GradlePluginDevelopmentTestSuiteInternal.pluginUnderTestMetadataTaskName(name), this.displayName);
        this.testTasks = (TestTaskView)objects.newInstance(TestTaskView.class, new Object[]{this.testTaskActions, providers.provider(new FinalizeComponentCallable()).orElse(this.getTestTaskCollection())});
        this.finalizeActions.add(new TestSuiteSourceSetExtendsFromTestedSourceSetIfPresentRule());
        this.finalizeActions.add(new CreateTestTasksFromTestingStrategiesRule(tasks, objects, this.getTestTaskCollection()));
        this.finalizeActions.add(new AttachTestTasksToCheckTaskIfPresent(pluginManager, tasks));
        this.finalizeActions.add(new FinalizeTestSuiteProperties());
        this.getSourceSet().finalizeValueOnRead();
        this.getTestingStrategies().finalizeValueOnRead();
    }

    public List<Action<? super Test>> getTestTaskActions() {
        return this.testTaskActions;
    }

    private static TaskProvider<PluginUnderTestMetadata> registerPluginUnderTestMetadataTask(TaskContainer tasks, String taskName, String displayName) {
        return tasks.register(taskName, PluginUnderTestMetadata.class, task -> {
            task.setGroup(PLUGIN_DEVELOPMENT_GROUP);
            task.setDescription(String.format(PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION_FORMAT, displayName));
        });
    }

    private static String pluginUnderTestMetadataTaskName(String testSuiteName) {
        return PLUGIN_UNDER_TEST_METADATA_TASK_NAME_PREFIX + StringUtils.capitalize((String)testSuiteName);
    }

    public String getName() {
        return this.name;
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(GradlePluginDevelopmentTestSuite.class);
    }

    @Override
    public GradlePluginTestingStrategyFactory getStrategies() {
        return this.strategyFactory;
    }

    public abstract SetProperty<Test> getTestTaskCollection();

    public String toString() {
        return "test suite '" + this.name + "'";
    }

    @Override
    public TaskView<Test> getTestTasks() {
        return this.testTasks;
    }

    @Override
    public TaskProvider<PluginUnderTestMetadata> getPluginUnderTestMetadataTask() {
        return this.pluginUnderTestMetadataTask;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void finalizeComponent() {
        if (!this.finalized) {
            this.finalized = true;
            this.finalizeActions.forEach(it -> it.execute((Object)this));
            this.getSourceSet().finalizeValue();
        }
    }

    @Override
    public boolean isFinalized() {
        return this.finalized;
    }

    public void whenFinalized(Action<? super GradlePluginDevelopmentTestSuite> action) {
        this.finalizeActions.add(action);
    }

    @Override
    public Dependencies getDependencies() {
        return this.dependencies;
    }

    @Override
    public void dependencies(Action<? super GradlePluginDevelopmentTestSuiteDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    private final class FinalizeComponentCallable<T>
    implements Callable<T> {
        private FinalizeComponentCallable() {
        }

        @Override
        public T call() throws Exception {
            GradlePluginDevelopmentTestSuiteInternal.this.finalizeComponent();
            return null;
        }
    }

    protected static abstract class Dependencies
    implements GradlePluginDevelopmentTestSuiteDependencies,
    Iterable<GradlePluginDevelopmentDependencyBucket> {
        private final PluginManager pluginManager;
        private final Provider<String> defaultGroovyVersion;
        private final DependencyFactory dependencyFactory;
        private final Supplier<NamedDomainObjectProvider<Configuration>> pluginUnderTestMetadataSupplier;
        private final Project project;
        private final Map<String, GradlePluginDevelopmentDependencyBucket> dependencyBuckets = new LinkedHashMap<String, GradlePluginDevelopmentDependencyBucket>();
        private final GradlePluginDevelopmentDependencyModifiers.DependencyModifier platformDependencyModifier;
        private final GradlePluginDevelopmentDependencyModifiers.DependencyModifier enforcedPlatformDependencyModifier;
        private final GradlePluginDevelopmentDependencyModifiers.DependencyModifier testFixturesDependencyModifier;
        private final Transformer<Dependency, String> localOrRemoteGradleTestKit;
        private final Transformer<Dependency, String> localOrRemoteGradleApi;

        private NamedDomainObjectProvider<Configuration> pluginUnderTestMetadata() {
            return this.pluginUnderTestMetadataSupplier.get();
        }

        @Inject
        public Dependencies(Project project, Provider<String> defaultGroovyVersion, GradlePluginDevelopmentTestSuite testSuite) {
            this.pluginManager = project.getPluginManager();
            this.defaultGroovyVersion = defaultGroovyVersion;
            this.dependencyFactory = DependencyFactory.forProject(project);
            this.localOrRemoteGradleTestKit = new LocalOrRemoteVersionTransformer<Dependency>(this.dependencyFactory::localGradleTestKit, this.dependencyFactory::gradleTestKit);
            this.localOrRemoteGradleApi = new LocalOrRemoteVersionTransformer<Dependency>(this.dependencyFactory::localGradleApi, this.dependencyFactory::gradleApi);
            this.pluginUnderTestMetadataSupplier = new PluginUnderTestMetadataConfigurationSupplier(project, testSuite);
            project.afterEvaluate(__ -> this.pluginUnderTestMetadataSupplier.get());
            DependencyBucketFactory bucketFactory = new DependencyBucketFactory(project, (Provider<SourceSet>)testSuite.getSourceSet());
            this.platformDependencyModifier = new PlatformDependencyModifier(project);
            this.enforcedPlatformDependencyModifier = new EnforcedPlatformDependencyModifier(project);
            this.testFixturesDependencyModifier = new TestFixturesDependencyModifier(project);
            this.project = project;
            this.add(bucketFactory.create("implementation"));
            this.add(bucketFactory.create("compileOnly"));
            this.add(bucketFactory.create("runtimeOnly"));
            this.add(bucketFactory.create("annotationProcessor"));
            this.add(bucketFactory.create(GradlePluginDevelopmentTestSuiteInternal.PLUGIN_UNDER_TEST_METADATA_TASK_NAME_PREFIX));
            this.add(bucketFactory.create("pluginUnderTest"));
        }

        private void add(GradlePluginDevelopmentDependencyBucket dependencyBucket) {
            this.dependencyBuckets.put(dependencyBucket.getName(), dependencyBucket);
        }

        @Override
        public void implementation(Object notation) {
            this.addDependency(this.getImplementation(), notation);
        }

        @Override
        public void implementation(Object notation, Action<? super ModuleDependency> action) {
            this.getImplementation().add((ModuleDependency)this.dependencyFactory.create(notation), action);
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getImplementation() {
            return this.dependencyBuckets.get("implementation");
        }

        @Override
        public void compileOnly(Object notation) {
            this.addDependency(this.getCompileOnly(), notation);
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getCompileOnly() {
            return this.dependencyBuckets.get("compileOnly");
        }

        @Override
        public void runtimeOnly(Object notation) {
            this.addDependency(this.getRuntimeOnly(), notation);
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getRuntimeOnly() {
            return this.dependencyBuckets.get("runtimeOnly");
        }

        @Override
        public void annotationProcessor(Object notation) {
            this.addDependency(this.getAnnotationProcessor(), notation);
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getAnnotationProcessor() {
            return this.dependencyBuckets.get("annotationProcessor");
        }

        @Override
        public void pluginUnderTestMetadata(Object notation) {
            this.addDependency(this.dependencyBuckets.get(GradlePluginDevelopmentTestSuiteInternal.PLUGIN_UNDER_TEST_METADATA_TASK_NAME_PREFIX), notation);
        }

        @Override
        public GradlePluginDevelopmentDependencyBucket getPluginUnderTest() {
            return this.dependencyBuckets.get("pluginUnderTest");
        }

        private void addDependency(GradlePluginDevelopmentDependencyBucket bucket, Object notation) {
            if (notation instanceof Provider) {
                bucket.add(((Provider)notation).map(this.dependencyFactory::create));
            } else {
                bucket.add(this.dependencyFactory.create(notation));
            }
        }

        @Override
        public NamedDomainObjectProvider<Configuration> getPluginUnderTestMetadata() {
            return this.pluginUnderTestMetadata();
        }

        @Override
        public ModuleDependency testFixtures(Object notation) {
            if (notation instanceof CharSequence) {
                return this.getTestFixtures().modify((CharSequence)notation);
            }
            if (notation instanceof ModuleDependency) {
                return this.getTestFixtures().modify((ModuleDependency)notation);
            }
            if (notation instanceof Project) {
                return this.getTestFixtures().modify(this.project);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public GradlePluginDevelopmentDependencyModifiers.DependencyModifier getTestFixtures() {
            return this.testFixturesDependencyModifier;
        }

        @Override
        public ModuleDependency platform(Object notation) {
            if (notation instanceof CharSequence) {
                return this.getPlatform().modify((CharSequence)notation);
            }
            if (notation instanceof ModuleDependency) {
                return this.getPlatform().modify((ModuleDependency)notation);
            }
            if (notation instanceof Project) {
                return this.getPlatform().modify(this.project);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public GradlePluginDevelopmentDependencyModifiers.DependencyModifier getPlatform() {
            return this.platformDependencyModifier;
        }

        @Override
        public GradlePluginDevelopmentDependencyModifiers.DependencyModifier getEnforcedPlatform() {
            return this.enforcedPlatformDependencyModifier;
        }

        @Override
        public ProjectDependency project(String projectPath) {
            return this.dependencyFactory.create(this.project.project(projectPath));
        }

        @Override
        public ProjectDependency project() {
            return this.dependencyFactory.create(this.project);
        }

        @Override
        public Object spockFramework() {
            return this.spockFramework("1.2-groovy-2.5");
        }

        @Override
        public Object spockFramework(String version) {
            this.pluginManager.apply("groovy-base");
            return this.dependencyFactory.spockFramework(version);
        }

        @Override
        public Object gradleFixtures() {
            return this.dependencyFactory.gradleFixtures();
        }

        @Override
        public Object gradleTestKit() {
            return this.dependencyFactory.localGradleTestKit();
        }

        @Override
        public Object gradleTestKit(String version) {
            return this.localOrRemoteGradleTestKit.transform((Object)version);
        }

        @Override
        public Object groovy() {
            return this.defaultGroovyVersion.map(this.dependencyFactory::groovy);
        }

        @Override
        public Object groovy(String version) {
            return this.dependencyFactory.groovy(version);
        }

        @Override
        public Object gradleApi(String version) {
            return this.localOrRemoteGradleApi.transform((Object)version);
        }

        @Override
        public Iterator<GradlePluginDevelopmentDependencyBucket> iterator() {
            return this.dependencyBuckets.values().iterator();
        }
    }

    protected static abstract class TestTaskView
    implements TaskView<Test> {
        private final List<Action<? super Test>> testTaskActions;
        private final Provider<Set<Test>> elementsProvider;

        @Inject
        public TestTaskView(List<Action<? super Test>> testTaskActions, Provider<Set<Test>> elementsProvider) {
            this.testTaskActions = testTaskActions;
            this.elementsProvider = elementsProvider;
        }

        @Override
        public void configureEach(Action<? super Test> action) {
            this.testTaskActions.add(action);
        }

        @Override
        public Provider<Set<Test>> getElements() {
            return this.elementsProvider;
        }
    }

    private static final class GUtil {
        private static final Pattern UPPER_LOWER = Pattern.compile("(?m)([A-Z]*)([a-z0-9]*)");

        private GUtil() {
        }

        public static String toWords(CharSequence string) {
            return GUtil.toWords(string, ' ');
        }

        public static String toWords(CharSequence string, char separator) {
            if (string == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            int pos = 0;
            Matcher matcher = UPPER_LOWER.matcher(string);
            while (pos < string.length()) {
                matcher.find(pos);
                if (matcher.end() == pos) {
                    ++pos;
                    continue;
                }
                if (builder.length() > 0) {
                    builder.append(separator);
                }
                String group1 = matcher.group(1).toLowerCase();
                String group2 = matcher.group(2);
                if (group2.length() == 0) {
                    builder.append(group1);
                } else {
                    if (group1.length() > 1) {
                        builder.append(group1.substring(0, group1.length() - 1));
                        builder.append(separator);
                        builder.append(group1.substring(group1.length() - 1));
                    } else {
                        builder.append(group1);
                    }
                    builder.append(group2);
                }
                pos = matcher.end();
            }
            return builder.toString();
        }
    }
}

