/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.GroovyGradlePluginDevelopmentExtension;
import dev.gradleplugins.JavaGradlePluginDevelopmentExtension;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.jvm.tasks.Jar;

public abstract class GradlePluginDevelopmentExtensionInternal
implements GroovyGradlePluginDevelopmentExtension,
JavaGradlePluginDevelopmentExtension {
    private final JavaPluginExtension java;
    private boolean defaultRepositoriesDisabled = System.getProperty("dev.gradleplugins.default-repositories", "enabled").equals("disabled");

    @Inject
    public GradlePluginDevelopmentExtensionInternal(JavaPluginExtension java) {
        this.java = java;
    }

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract SoftwareComponentContainer getComponents();

    @Override
    public void withSourcesJar() {
        this.java.withSourcesJar();
    }

    @Override
    public void withJavadocJar() {
        this.java.withJavadocJar();
    }

    @Override
    public void disableDefaultRepositories() {
        this.defaultRepositoriesDisabled = true;
    }

    public boolean isDefaultRepositoriesDisabled() {
        return this.defaultRepositoriesDisabled;
    }

    @Override
    public void withGroovydocJar() {
        Configuration variant = (Configuration)this.getConfigurations().maybeCreate("groovydocElements");
        variant.setVisible(false);
        variant.setDescription("groovydoc elements for main.");
        variant.setCanBeResolved(false);
        variant.setCanBeConsumed(true);
        variant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.getObjects().named(Usage.class, "java-runtime")));
        variant.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getObjects().named(Category.class, "documentation")));
        variant.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.getObjects().named(Bundling.class, "external")));
        variant.getAttributes().attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)this.getObjects().named(DocsType.class, "groovydoc")));
        String jarTaskName = "groovydocJar";
        if (!this.getTasks().getNames().contains(jarTaskName)) {
            TaskProvider jarTask = this.getTasks().register(jarTaskName, Jar.class, task -> {
                TaskProvider groovydocTask = this.getTasks().named("groovydoc", Groovydoc.class);
                task.dependsOn(new Object[]{groovydocTask});
                task.setDescription("Assembles a jar archive containing the main groovydoc.");
                task.setGroup("build");
                task.getArchiveClassifier().set((Object)"groovydoc");
                task.from(new Object[]{groovydocTask.map(Groovydoc::getDestinationDir)});
            });
            if (this.getTasks().getNames().contains("assemble")) {
                this.getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{jarTask}));
            }
        }
        TaskProvider jar = this.getTasks().named(jarTaskName, Jar.class);
        variant.getOutgoing().artifact((Object)jar, it -> {
            it.setName(jar.getName());
            it.setType("jar");
            it.builtBy(new Object[]{jar});
        });
        AdhocComponentWithVariants component = GradlePluginDevelopmentExtensionInternal.findJavaComponent(this.getComponents());
        if (component != null) {
            component.addVariantsFromConfiguration(variant, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    @Nullable
    private static AdhocComponentWithVariants findJavaComponent(SoftwareComponentContainer components) {
        SoftwareComponent component = (SoftwareComponent)components.findByName("java");
        if (component instanceof AdhocComponentWithVariants) {
            return (AdhocComponentWithVariants)component;
        }
        return null;
    }
}

