/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.GradleVersion;

public abstract class GradleCompatibilities {
    public abstract Property<String> getMinimumGradleVersion();

    public abstract Property<String> getGradleApiVersion();

    static abstract class DefaultGradleCompatibility
    extends ForSourceSetExtension.SourceSetGradleCompatibilities
    implements Named {
        private final SourceSet sourceSet;

        @Inject
        public DefaultGradleCompatibility(SourceSet sourceSet) {
            this.sourceSet = sourceSet;
        }

        public String getName() {
            return this.sourceSet.getName();
        }

        @Override
        public SourceSet getSourceSet() {
            return this.sourceSet;
        }
    }

    static abstract class GradleCompatibilitiesExtension
    implements ForSourceSetExtension {
        private final ObjectFactory objects;
        private final NamedDomainObjectSet<ForSourceSetExtension.SourceSetGradleCompatibilities> compatibilities;

        @Inject
        public GradleCompatibilitiesExtension(ObjectFactory objects) {
            this.objects = objects;
            this.compatibilities = objects.namedDomainObjectSet(ForSourceSetExtension.SourceSetGradleCompatibilities.class);
        }

        @Override
        public NamedDomainObjectProvider<ForSourceSetExtension.SourceSetGradleCompatibilities> forSourceSet(SourceSet sourceSet) {
            if (this.compatibilities.findByName(sourceSet.getName()) == null) {
                this.compatibilities.add((Object)((ForSourceSetExtension.SourceSetGradleCompatibilities)this.objects.newInstance(DefaultGradleCompatibility.class, new Object[]{sourceSet})));
            }
            return this.compatibilities.named(sourceSet.getName());
        }

        @Override
        public void configureEach(Action<? super ForSourceSetExtension.SourceSetGradleCompatibilities> action) {
            this.compatibilities.configureEach(action);
        }
    }

    public static interface ForSourceSetExtension {
        public NamedDomainObjectProvider<SourceSetGradleCompatibilities> forSourceSet(SourceSet var1);

        public void configureEach(Action<? super SourceSetGradleCompatibilities> var1);

        public static abstract class SourceSetGradleCompatibilities
        extends GradleCompatibilities {
            public abstract SourceSet getSourceSet();
        }
    }

    static abstract class Rule
    implements Plugin<Project> {
        @Inject
        public Rule() {
        }

        public void apply(Project project) {
            GradleCompatibilitiesExtension extension = (GradleCompatibilitiesExtension)project.getExtensions().create("$gradleCompatibilities", GradleCompatibilitiesExtension.class, new Object[0]);
            extension.configureEach((Action<? super ForSourceSetExtension.SourceSetGradleCompatibilities>)new Action<GradleCompatibilities>(){

                public void execute(GradleCompatibilities it) {
                    it.getGradleApiVersion().convention(it.getMinimumGradleVersion().map(this.toLocalIfGradleSnapshotVersion()));
                    it.getGradleApiVersion().finalizeValueOnRead();
                }

                private Transformer<String, String> toLocalIfGradleSnapshotVersion() {
                    return it -> {
                        if (GradleVersion.version((String)it).isSnapshot()) {
                            return "local";
                        }
                        return it;
                    };
                }
            });
        }
    }
}

