/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.rules;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.internal.FinalizableComponent;
import dev.gradleplugins.internal.GradleCompatibilities;
import dev.gradleplugins.internal.JvmCompatibilities;
import dev.gradleplugins.internal.util.ActionSet;
import dev.gradleplugins.internal.util.Configurable;
import dev.gradleplugins.internal.util.GradlePluginDevelopmentUtils;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.util.GradleVersion;

abstract class GradlePluginDevelopmentCompatibilityExtensionRule
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "compatibility";

    @Inject
    public GradlePluginDevelopmentCompatibilityExtensionRule() {
    }

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java-gradle-plugin", __ -> {
            project.getPluginManager().apply("gradlepluginsdev.rules.gradle-compatibilities");
            DefaultGradlePluginDevelopmentCompatibilityExtension extension = this.newCompatibilityExtension(project);
            ((ExtensionAware)GradlePluginDevelopmentUtils.gradlePlugin(project)).getExtensions().add(EXTENSION_NAME, (Object)extension);
            project.afterEvaluate(GradlePluginDevelopmentCompatibilityExtensionRule.finalize(extension));
        });
    }

    private DefaultGradlePluginDevelopmentCompatibilityExtension newCompatibilityExtension(Project project) {
        return (DefaultGradlePluginDevelopmentCompatibilityExtension)project.getObjects().newInstance(DefaultGradlePluginDevelopmentCompatibilityExtension.class, new Object[]{project});
    }

    private static Action<Project> finalize(DefaultGradlePluginDevelopmentCompatibilityExtension extension) {
        return ignored -> extension.finalizeComponent();
    }

    static abstract class DefaultGradlePluginDevelopmentCompatibilityExtension
    implements GradlePluginDevelopmentCompatibilityExtension,
    HasPublicType,
    FinalizableComponent,
    Configurable<GradlePluginDevelopmentCompatibilityExtension> {
        private boolean finalized = false;
        private final GradleCompatibilitiesProvider provider;
        private final Runnable finalizeSourceCompatibilityForBackwardCompatibility;
        private final Runnable overrideProjectJvmCompatibilitiesForBackwardCompatibility;
        private final GradlePluginDevelopmentCompatibilityExtensionAdapter.Factory adapterFactory;

        private static SourceSet pluginSourceSetOf(Project project) {
            return ((GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class)).getPluginSourceSet();
        }

        @Inject
        public DefaultGradlePluginDevelopmentCompatibilityExtension(Project project) {
            this.provider = new GradleCompatibilitiesProvider(project);
            this.finalizeSourceCompatibilityForBackwardCompatibility = () -> ((JvmCompatibilities.ForSourceSetExtension)project.getExtensions().getByType(JvmCompatibilities.ForSourceSetExtension.class)).forSourceSet(DefaultGradlePluginDevelopmentCompatibilityExtension.pluginSourceSetOf(project)).configure(x -> x.getSourceCompatibility().finalizeValue());
            this.overrideProjectJvmCompatibilitiesForBackwardCompatibility = () -> project.getExtensions().configure(JavaPluginExtension.class, java -> {
                JvmCompatibilities.ForSourceSetExtension.SourceSetJvmCompatibilities jvmCompatibilities = (JvmCompatibilities.ForSourceSetExtension.SourceSetJvmCompatibilities)((JvmCompatibilities.ForSourceSetExtension)project.getExtensions().getByType(JvmCompatibilities.ForSourceSetExtension.class)).forSourceSet(DefaultGradlePluginDevelopmentCompatibilityExtension.pluginSourceSetOf(project)).get();
                java.setTargetCompatibility((JavaVersion)jvmCompatibilities.getTargetCompatibility().get());
                java.setSourceCompatibility((JavaVersion)jvmCompatibilities.getSourceCompatibility().get());
            });
            this.adapterFactory = new GradlePluginDevelopmentCompatibilityExtensionAdapter.Factory(project.getObjects());
        }

        public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(GradlePluginDevelopmentCompatibilityExtension.class);
        }

        @Override
        public Property<String> getMinimumGradleVersion() {
            return this.provider.get().getMinimumGradleVersion();
        }

        @Override
        public Property<String> getGradleApiVersion() {
            return this.provider.get().getGradleApiVersion();
        }

        @Override
        public void finalizeComponent() {
            if (!this.finalized) {
                this.provider.finalizeProvider();
                this.provider.configure((Action<? super GradleCompatibilities>)((Action)it -> {
                    this.finalizeSourceCompatibilityForBackwardCompatibility.run();
                    this.overrideProjectJvmCompatibilitiesForBackwardCompatibility.run();
                    it.getGradleApiVersion().finalizeValue();
                    it.getGradleApiVersion().disallowChanges();
                    it.getMinimumGradleVersion().convention((Object)GradleVersion.current().getVersion());
                    it.getMinimumGradleVersion().disallowChanges();
                }));
                this.finalized = true;
            }
        }

        @Override
        public boolean isFinalized() {
            return this.finalized;
        }

        @Override
        public void configure(Action<? super GradlePluginDevelopmentCompatibilityExtension> action) {
            this.provider.configure((Action<? super GradleCompatibilities>)((Action)delegate -> action.execute((Object)this.adapterFactory.create((GradleCompatibilities)delegate))));
        }

        static abstract class GradlePluginDevelopmentCompatibilityExtensionAdapter
        implements GradlePluginDevelopmentCompatibilityExtension {
            private final GradleCompatibilities delegate;

            @Inject
            public GradlePluginDevelopmentCompatibilityExtensionAdapter(GradleCompatibilities delegate) {
                this.delegate = delegate;
            }

            @Override
            public Property<String> getMinimumGradleVersion() {
                return this.delegate.getMinimumGradleVersion();
            }

            @Override
            public Property<String> getGradleApiVersion() {
                return this.delegate.getGradleApiVersion();
            }

            static final class Factory {
                private final ObjectFactory objects;

                public Factory(ObjectFactory objects) {
                    this.objects = objects;
                }

                public GradlePluginDevelopmentCompatibilityExtensionAdapter create(GradleCompatibilities delegate) {
                    return (GradlePluginDevelopmentCompatibilityExtensionAdapter)this.objects.newInstance(GradlePluginDevelopmentCompatibilityExtensionAdapter.class, new Object[]{delegate});
                }
            }
        }

        private static final class GradleCompatibilitiesProvider {
            private Project project;
            private ActionSet<GradleCompatibilities> actions = new ActionSet();
            private NamedDomainObjectProvider<? extends GradleCompatibilities> provider;

            public GradleCompatibilitiesProvider(Project project) {
                this.project = project;
            }

            public void configure(Action<? super GradleCompatibilities> action) {
                if (this.provider == null) {
                    this.actions.add(action);
                } else {
                    this.provider.configure(action);
                }
            }

            private void finalizeProvider() {
                if (this.provider == null) {
                    this.provider = ((GradleCompatibilities.ForSourceSetExtension)this.project.getExtensions().getByType(GradleCompatibilities.ForSourceSetExtension.class)).forSourceSet(DefaultGradlePluginDevelopmentCompatibilityExtension.pluginSourceSetOf(this.project));
                    this.provider.configure(this.actions);
                    this.actions = null;
                    this.project = null;
                }
            }

            public GradleCompatibilities get() {
                this.finalizeProvider();
                return (GradleCompatibilities)this.provider.get();
            }
        }
    }
}

