/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.rules;

import dev.gradleplugins.GradleRuntimeCompatibility;
import dev.gradleplugins.internal.GradleCompatibilities;
import dev.gradleplugins.internal.JvmCompatibilities;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;

abstract class GradleJvmCompatibilitiesRule
implements Plugin<Project> {
    @Inject
    public GradleJvmCompatibilitiesRule() {
    }

    public void apply(final Project project) {
        project.getPluginManager().withPlugin("java-base", __ -> {
            project.getPluginManager().apply("gradlepluginsdev.rules.jvm-compatibilities");
            project.getPluginManager().apply("gradlepluginsdev.rules.gradle-compatibilities");
            ((GradleCompatibilities.ForSourceSetExtension)project.getExtensions().getByType(GradleCompatibilities.ForSourceSetExtension.class)).configureEach((Action<? super GradleCompatibilities.ForSourceSetExtension.SourceSetGradleCompatibilities>)new Action<GradleCompatibilities.ForSourceSetExtension.SourceSetGradleCompatibilities>(){

                public void execute(GradleCompatibilities.ForSourceSetExtension.SourceSetGradleCompatibilities gradle) {
                    ((JvmCompatibilities.ForSourceSetExtension)project.getExtensions().getByType(JvmCompatibilities.ForSourceSetExtension.class)).forSourceSet(gradle.getSourceSet()).configure(jvm -> jvm.getSourceCompatibility().set(this.sourceCompatibilityOf(project).orElse(this.sourceCompatibilityOf(gradle)).orElse((Object)JavaVersion.current())));
                }

                private Provider<JavaVersion> sourceCompatibilityOf(Project project2) {
                    JvmCompatibilities.ForProjectExtension jvmCompatibilities = (JvmCompatibilities.ForProjectExtension)project2.getExtensions().getByType(JvmCompatibilities.ForProjectExtension.class);
                    return jvmCompatibilities.getSourceCompatibility();
                }

                private Provider<JavaVersion> sourceCompatibilityOf(GradleCompatibilities gradle) {
                    return gradle.getMinimumGradleVersion().map(GradleRuntimeCompatibility::minimumJavaVersionFor);
                }
            });
        });
    }
}

