/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.GradlePluginDevelopmentDependencyBucket;
import dev.gradleplugins.internal.DependencyFactory;
import dev.gradleplugins.internal.util.FilterTransformer;
import dev.gradleplugins.internal.util.PeekTransformer;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public final class DependencyBucketFactory {
    private final Project project;
    private final Provider<SourceSet> sourceSetProvider;

    public DependencyBucketFactory(Project project, Provider<SourceSet> sourceSetProvider) {
        this.project = project;
        this.sourceSetProvider = sourceSetProvider;
    }

    public GradlePluginDevelopmentDependencyBucket create(String bucketName) {
        return new DefaultDependencyBucket(bucketName);
    }

    public final class DefaultDependencyBucket
    implements GradlePluginDevelopmentDependencyBucket {
        private final String dependencyBucketName;
        private final DependencyFactory dependencyFactory;
        private final Provider<Configuration> configurationProvider;
        private final Provider<String> configurationNameProvider;

        public DefaultDependencyBucket(String dependencyBucketName) {
            this.dependencyBucketName = dependencyBucketName;
            this.dependencyFactory = DependencyFactory.forProject(DependencyBucketFactory.this.project);
            this.configurationNameProvider = DependencyBucketFactory.this.sourceSetProvider.map(sourceSet -> {
                String sourceSetName = sourceSet.getName();
                if (sourceSet.getName().equals("main")) {
                    return dependencyBucketName;
                }
                return sourceSetName + StringUtils.capitalize((String)dependencyBucketName);
            });
            this.configurationProvider = this.configurationNameProvider.map(arg_0 -> ((ConfigurationContainer)DependencyBucketFactory.this.project.getConfigurations()).getByName(arg_0));
        }

        public String getName() {
            return this.dependencyBucketName;
        }

        private <T> Provider<? extends Iterable<T>> asCollectionProvider(Provider<? extends Iterable<? extends T>> provider) {
            return DependencyBucketFactory.this.project.getObjects().listProperty(Object.class).value(provider);
        }

        private <T> Provider<? extends Iterable<T>> asList(Provider<T> provider) {
            return provider.map(Collections::singletonList).orElse(Collections.emptyList());
        }

        private Provider<String> ifThisBucket(Configuration configuration) {
            return this.configurationNameProvider.map(FilterTransformer.filter(it -> it.equals(configuration.getName())));
        }

        @Override
        public void add(Dependency dependency) {
            DependencyBucketFactory.this.project.getConfigurations().configureEach(this.usingWorkaroundForBadlyCodedKotlinPlugin((it, dependencies) -> dependencies.addAllLater(this.asCollectionProvider(this.asList(this.ifThisBucket((Configuration)it).map(__ -> dependency))))));
        }

        @Override
        public <DependencyType extends Dependency> void add(DependencyType dependency, Action<? super DependencyType> configureAction) {
            configureAction.execute(dependency);
            this.add(dependency);
        }

        @Override
        public <DependencyType extends Dependency> void add(Provider<DependencyType> dependencyProvider) {
            DependencyBucketFactory.this.project.getConfigurations().configureEach(this.usingWorkaroundForBadlyCodedKotlinPlugin((it, dependencies) -> dependencies.addAllLater(this.asCollectionProvider(this.asList(this.ifThisBucket((Configuration)it).flatMap(__ -> dependencyProvider))))));
        }

        private Action<Configuration> usingWorkaroundForBadlyCodedKotlinPlugin(BiConsumer<? super Configuration, ? super DependencySet> action) {
            return it -> it.withDependencies(dependencies -> action.accept((Configuration)it, (DependencySet)dependencies));
        }

        @Override
        public <DependencyType extends Dependency> void add(Provider<DependencyType> dependencyProvider, Action<? super DependencyType> configureAction) {
            this.add(dependencyProvider.map(PeekTransformer.peek(configureAction)));
        }

        @Override
        public void add(FileCollection fileCollection) {
            this.add((Dependency)this.dependencyFactory.create(fileCollection));
        }

        @Override
        public void add(Project project) {
            this.add((Dependency)this.dependencyFactory.create(project));
        }

        @Override
        public void add(CharSequence dependencyNotation) {
            this.add((Dependency)this.dependencyFactory.create(dependencyNotation));
        }

        @Override
        public void add(CharSequence dependencyNotation, Action<? super ExternalModuleDependency> configureAction) {
            this.add((Dependency)this.dependencyFactory.create(dependencyNotation), (Action)configureAction);
        }

        @Override
        public Provider<Configuration> getAsConfiguration() {
            return this.configurationProvider;
        }
    }
}

