/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.internal.plugins.AddGradleApiDependencyToCompileOnlyApiConfiguration;
import dev.gradleplugins.internal.plugins.RemoveGradleApiProjectDependency;
import dev.gradleplugins.internal.plugins.RemoveTestSourceSets;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

abstract class GradlePluginDevelopmentBasePlugin
implements Plugin<Project> {
    @Inject
    public GradlePluginDevelopmentBasePlugin() {
    }

    public void apply(Project project) {
        project.getPluginManager().apply("gradlepluginsdev.rules.gradle-jvm-compatibilities");
        project.getPluginManager().apply("gradlepluginsdev.rules.project-extensions");
        project.getPluginManager().apply("gradlepluginsdev.rules.gradle-plugin-compatibility-extension");
        GradlePluginDevelopmentBasePlugin.whenPluginApplied("java-gradle-plugin", new RemoveGradleApiProjectDependency()).execute((Object)project);
        GradlePluginDevelopmentBasePlugin.whenPluginApplied("java-gradle-plugin", new AddGradleApiDependencyToCompileOnlyApiConfiguration()).execute((Object)project);
        GradlePluginDevelopmentBasePlugin.whenPluginApplied("java-gradle-plugin", new RemoveTestSourceSets()).execute((Object)project);
    }

    private static Action<Project> whenPluginApplied(String pluginId, Action<? super Project> action) {
        return new WhenPluginAppliedAction(pluginId, action);
    }

    private static final class WhenPluginAppliedAction
    implements Action<Project> {
        private final String pluginId;
        private final Action<? super Project> delegate;

        private WhenPluginAppliedAction(String pluginId, Action<? super Project> delegate) {
            this.pluginId = pluginId;
            this.delegate = delegate;
        }

        public void execute(Project project) {
            project.getPluginManager().withPlugin(this.pluginId, __ -> this.delegate.execute((Object)project));
        }
    }
}

