/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.gradleplugins.internal.GradleVersionsService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.gradle.api.resources.TextResourceFactory;

public class ReleasedVersionDistributions {
    public static final ReleasedVersionDistributions GRADLE_DISTRIBUTIONS = new ReleasedVersionDistributions();
    private GradleRelease mostRecentSnapshot;
    private GradleRelease mostRecentRelease;
    private List<GradleRelease> allVersions;
    private final GradleVersionsService versions;

    public ReleasedVersionDistributions() {
        this(new HostedGradleVersionsService());
    }

    public ReleasedVersionDistributions(TextResourceFactory textResourceFactory) {
        this(new TextResourceHostedGradleVersionsService(textResourceFactory));
    }

    public ReleasedVersionDistributions(GradleVersionsService versions) {
        this.versions = versions;
    }

    public GradleRelease getMostRecentSnapshot() {
        if (this.mostRecentSnapshot == null) {
            try (Reader reader = this.versions.nightly();){
                this.mostRecentSnapshot = (GradleRelease)new Gson().fromJson(reader, GradleRelease.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get the last snapshot version", e);
            }
        }
        return this.mostRecentSnapshot;
    }

    public GradleRelease getMostRecentRelease() {
        if (this.mostRecentRelease == null) {
            try (Reader reader = this.versions.current();){
                this.mostRecentRelease = (GradleRelease)new Gson().fromJson(reader, GradleRelease.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get the last version", e);
            }
        }
        return this.mostRecentRelease;
    }

    public List<GradleRelease> getAllVersions() {
        if (this.allVersions == null) {
            try (Reader reader = this.versions.all();){
                this.allVersions = (List)new Gson().fromJson(reader, new TypeToken<List<GradleRelease>>(){}.getType());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get the last version", e);
            }
        }
        return this.allVersions;
    }

    private static final class TextResourceHostedGradleVersionsService
    implements GradleVersionsService {
        private final TextResourceFactory textResourceFactory;

        public TextResourceHostedGradleVersionsService(TextResourceFactory textResourceFactory) {
            this.textResourceFactory = textResourceFactory;
        }

        @Override
        public Reader nightly() throws IOException {
            return this.textResourceFactory.fromUri((Object)"https://services.gradle.org/versions/nightly").asReader();
        }

        @Override
        public Reader current() throws IOException {
            return this.textResourceFactory.fromUri((Object)"https://services.gradle.org/versions/current").asReader();
        }

        @Override
        public Reader all() throws IOException {
            return this.textResourceFactory.fromUri((Object)"https://services.gradle.org/versions/all").asReader();
        }
    }

    private static final class HostedGradleVersionsService
    implements GradleVersionsService {
        private HostedGradleVersionsService() {
        }

        @Override
        public Reader nightly() throws IOException {
            return new InputStreamReader(new URL("https://services.gradle.org/versions/nightly").openConnection().getInputStream());
        }

        @Override
        public Reader current() throws IOException {
            return new InputStreamReader(new URL("https://services.gradle.org/versions/current").openConnection().getInputStream());
        }

        @Override
        public Reader all() throws IOException {
            return new InputStreamReader(new URL("https://services.gradle.org/versions/all").openConnection().getInputStream());
        }
    }

    public static final class GradleRelease {
        private final String version;
        private final boolean snapshot;
        private final boolean current;
        private final String rcFor;

        public GradleRelease(String version, boolean snapshot, boolean current, String rcFor) {
            this.version = version;
            this.snapshot = snapshot;
            this.current = current;
            this.rcFor = rcFor;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isSnapshot() {
            return this.snapshot;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public String getRcFor() {
            return this.rcFor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GradleRelease that = (GradleRelease)o;
            return this.snapshot == that.snapshot && this.current == that.current && Objects.equals(this.version, that.version) && Objects.equals(this.rcFor, that.rcFor);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.snapshot, this.current, this.rcFor);
        }
    }
}

