/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.jvm;

import dev.gradleplugins.internal.jvm.JvmCompatibilityProperty;
import java.util.Objects;
import org.gradle.api.JavaVersion;

public final class FinalizableJvmCompatibilityPropertyAdapter
implements JvmCompatibilityProperty {
    private final JvmCompatibilityProperty delegate;
    private final JavaVersion initialValue;

    public FinalizableJvmCompatibilityPropertyAdapter(JvmCompatibilityProperty delegate) {
        this.delegate = delegate;
        this.initialValue = delegate.get();
        delegate.set(JavaVersion.VERSION_1_1);
    }

    @Override
    public JavaVersion get() {
        return this.delegate.get();
    }

    @Override
    public void set(JavaVersion value) {
        Objects.requireNonNull(value);
        if (this.delegate.get().equals((Object)JavaVersion.VERSION_1_1)) {
            this.delegate.set(value);
        }
    }

    @Override
    public void finalizeValue() {
        if (this.delegate.get().equals((Object)JavaVersion.VERSION_1_1)) {
            this.delegate.set(this.initialValue);
        }
    }
}

