/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.GroovyGradlePluginDevelopmentExtension;
import dev.gradleplugins.JavaGradlePluginDevelopmentExtension;
import dev.gradleplugins.internal.GradlePluginDevelopmentExtensionInternal;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenRepositoryContentDescriptor;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;

public abstract class DeferredRepositoryFactory {
    private final Project project;

    @Inject
    public DeferredRepositoryFactory(Project project) {
        this.project = project;
    }

    public void groovy() {
        this.project.afterEvaluate(DeferredRepositoryFactory::createGroovyRepository);
    }

    public void spock() {
        this.project.afterEvaluate(DeferredRepositoryFactory::createSpockRepository);
    }

    private static void mutateRepositories(Project project, Action<? super RepositoryHandler> action) {
        ExtensionAware extension = (ExtensionAware)project.getExtensions().findByType(GradlePluginDevelopmentExtension.class);
        if (extension == null) {
            action.execute((Object)project.getRepositories());
        } else {
            boolean defaultRepositoriesDisabled = ((GradlePluginDevelopmentExtensionInternal)Optional.ofNullable(extension.getExtensions().findByType(JavaGradlePluginDevelopmentExtension.class)).orElseGet(() -> (GroovyGradlePluginDevelopmentExtension)extension.getExtensions().findByType(GroovyGradlePluginDevelopmentExtension.class))).isDefaultRepositoriesDisabled();
            if (!defaultRepositoriesDisabled) {
                action.execute((Object)project.getRepositories());
            }
        }
    }

    private static void createGroovyRepository(Project project) {
        DeferredRepositoryFactory.mutateRepositories(project, (Action<? super RepositoryHandler>)((Action)repositories -> ((MavenArtifactRepository)repositories.withType(MavenArtifactRepository.class).getByName("Gradle Plugin Development")).mavenContent(DeferredRepositoryFactory.allowGroovy()::accept)));
    }

    private static void createSpockRepository(Project project) {
        DeferredRepositoryFactory.mutateRepositories(project, (Action<? super RepositoryHandler>)((Action)repositories -> ((MavenArtifactRepository)repositories.withType(MavenArtifactRepository.class).getByName("Gradle Plugin Development")).mavenContent(DeferredRepositoryFactory.allowSpock().andThen(DeferredRepositoryFactory.allowGroovy())::accept)));
    }

    public static Consumer<MavenRepositoryContentDescriptor> allowSpock() {
        return content -> {
            content.includeModule("org.spockframework", "spock-bom");
            content.includeModule("org.spockframework", "spock-core");
            content.includeModule("junit", "junit");
            content.includeModule("org.hamcrest", "hamcrest-core");
            content.includeModule("org.hamcrest", "hamcrest-parent");
        };
    }

    private static Consumer<MavenRepositoryContentDescriptor> allowGroovy() {
        return content -> {
            content.includeGroup("org.codehaus.groovy");
            content.includeModule("junit", "junit");
            content.includeModule("org.hamcrest", "hamcrest-core");
            content.includeModule("jline", "jline");
            content.includeModule("com.thoughtworks.qdox", "qdox");
            content.includeModule("commons-cli", "commons-cli");
            content.includeModule("info.picocli", "picocli");
            content.includeModule("org.apache.ant", "ant");
            content.includeModule("org.apache.ant", "ant-parent");
            content.includeModule("org.apache.ant", "ant-antlr");
            content.includeModule("org.apache.ant", "ant-junit");
            content.includeModule("org.apache.ant", "ant-launcher");
            content.includeModule("org.apache.commons", "commons-parent");
            content.includeModule("org.codehaus", "codehaus-parent");
            content.includeModule("org.sonatype.oss", "oss-parent");
            content.includeModule("org.hamcrest", "hamcrest-parent");
            content.includeModule("org.apache", "apache");
            content.includeModule("org.apiguardian", "apiguardian-api");
            content.includeModule("org.junit.platform", "junit-platform-launcher");
            content.includeModule("org.junit.platform", "junit-platform-engine");
            content.includeModule("org.opentest4j", "opentest4j");
            content.includeModule("org.junit.platform", "junit-platform-commons");
            content.includeModule("org.testng", "testng");
            content.includeModule("com.beust", "jcommander");
            content.includeModule("org.junit.jupiter", "junit-jupiter-api");
            content.includeModule("org.junit.jupiter", "junit-jupiter-engine");
        };
    }
}

