/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.GradlePluginDevelopmentTestSuite;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.plugin.devel.tasks.PluginUnderTestMetadata;

public final class ConfigurePluginUnderTestMetadataTask
implements Action<GradlePluginDevelopmentTestSuite> {
    private final Project project;

    public ConfigurePluginUnderTestMetadataTask(Project project) {
        this.project = project;
    }

    public void execute(GradlePluginDevelopmentTestSuite testSuite) {
        testSuite.getPluginUnderTestMetadataTask().configure(task -> {
            task.getOutputDirectory().convention(this.project.getLayout().getBuildDirectory().dir(task.getName()));
            task.getPluginClasspath().from(new Object[]{testSuite.getTestedSourceSet().map(ConfigurePluginUnderTestMetadataTask.asPluginClasspath(this.project))});
        });
        ConfigurePluginUnderTestMetadataTask.ignorePluginUnderTestMetadataFile(this.project);
        ConfigurePluginUnderTestMetadataTask.configurePluginUnderTestMetadataAsTestInputs(testSuite);
        ConfigurePluginUnderTestMetadataTask.configurePluginUnderTestMetadataAsRuntimeOnlyDependencies(this.project, testSuite);
    }

    private static void configurePluginUnderTestMetadataAsRuntimeOnlyDependencies(Project project, GradlePluginDevelopmentTestSuite testSuite) {
        testSuite.getDependencies().runtimeOnly(project.getLayout().files(new Object[]{testSuite.getPluginUnderTestMetadataTask()}));
    }

    private static void configurePluginUnderTestMetadataAsTestInputs(GradlePluginDevelopmentTestSuite testSuite) {
        testSuite.getTestTasks().configureEach((Action<Test>)((Action)task -> task.getInputs().files(new Object[]{testSuite.getPluginUnderTestMetadataTask().map(PluginUnderTestMetadata::getPluginClasspath)}).withPropertyName("pluginUnderTestClasspath").withNormalizer(ClasspathNormalizer.class)));
    }

    private static void ignorePluginUnderTestMetadataFile(Project project) {
        project.getNormalization().getRuntimeClasspath().ignore("plugin-under-test-metadata.properties");
    }

    private static Transformer<Object, SourceSet> asPluginClasspath(Project project) {
        return sourceSet -> {
            Configuration runtimeClasspath = project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName());
            ArtifactView view = runtimeClasspath.getIncoming().artifactView(config -> config.componentFilter(componentId -> {
                if (componentId instanceof OpaqueComponentIdentifier) {
                    return !componentId.getDisplayName().equals(DependencyFactory.ClassPathNotation.GRADLE_API.displayName) && !componentId.getDisplayName().equals(DependencyFactory.ClassPathNotation.LOCAL_GROOVY.displayName);
                }
                return true;
            }));
            return sourceSet.getOutput().plus(view.getFiles());
        };
    }
}

