/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.Nullable;

public final class JarBasedPublishArtifact
implements PublishArtifact {
    private final TaskProvider<Jar> jarTaskProvider;

    public JarBasedPublishArtifact(TaskProvider<Jar> jarTaskProvider) {
        this.jarTaskProvider = jarTaskProvider;
    }

    public String getName() {
        return this.jarTaskProvider.getName();
    }

    public String getExtension() {
        return "jar";
    }

    public String getType() {
        return "jar";
    }

    @Nullable
    public String getClassifier() {
        return (String)((Jar)this.jarTaskProvider.get()).getArchiveClassifier().getOrNull();
    }

    public File getFile() {
        return ((RegularFile)((Jar)this.jarTaskProvider.get()).getArchiveFile().get()).getAsFile();
    }

    @Nullable
    public Date getDate() {
        return null;
    }

    public TaskDependency getBuildDependencies() {
        return new TaskDependency(){

            public Set<? extends Task> getDependencies(@Nullable Task task) {
                return Collections.singleton((Jar)JarBasedPublishArtifact.this.jarTaskProvider.get());
            }
        };
    }
}

