/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradleRuntimeCompatibility;
import dev.gradleplugins.GroovyGradlePluginDevelopmentExtension;
import dev.gradleplugins.internal.DeferredRepositoryFactory;
import dev.gradleplugins.internal.GradlePluginDevelopmentDependencyExtensionInternal;
import dev.gradleplugins.internal.GradlePluginDevelopmentExtensionInternal;
import dev.gradleplugins.internal.plugins.AbstractGradlePluginDevelopmentPlugin;
import dev.gradleplugins.internal.util.GradlePluginDevelopmentUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.util.GradleVersion;

public class GroovyGradlePluginDevelopmentPlugin
implements Plugin<Project> {
    private static final String PLUGIN_ID = "dev.gradleplugins.groovy-gradle-plugin";

    public void apply(Project project) {
        AbstractGradlePluginDevelopmentPlugin.assertOtherGradlePluginDevelopmentPluginsAreNeverApplied(project.getPluginManager(), PLUGIN_ID);
        AbstractGradlePluginDevelopmentPlugin.assertJavaGradlePluginIsNotPreviouslyApplied(project.getPluginManager(), PLUGIN_ID);
        AbstractGradlePluginDevelopmentPlugin.assertKotlinDslPluginIsNeverApplied(project.getPluginManager(), PLUGIN_ID);
        project.getPluginManager().apply("dev.gradleplugins.gradle-plugin-base");
        project.getPluginManager().apply("dev.gradleplugins.gradle-plugin-testing-base");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            project.getPluginManager().apply("groovy-gradle-plugin");
        } else {
            project.getPluginManager().apply("java-gradle-plugin");
        }
        project.getPluginManager().apply("groovy");
        GradlePluginDevelopmentExtensionInternal groovy = AbstractGradlePluginDevelopmentPlugin.registerLanguageExtension(project, "groovy", GroovyGradlePluginDevelopmentExtension.class);
        GradlePluginDevelopmentCompatibilityExtension extension = GradlePluginDevelopmentCompatibilityExtension.compatibility(GradlePluginDevelopmentUtils.gradlePlugin(project));
        groovy.getGroovyVersion().convention(extension.getMinimumGradleVersion().map(GradleRuntimeCompatibility::groovyVersionOf));
        GradlePluginDevelopmentDependencyExtensionInternal dependencies = GradlePluginDevelopmentDependencyExtensionInternal.of(project.getDependencies());
        dependencies.add("compileOnly", (Provider<Object>)groovy.getGroovyVersion().map(dependencies::groovy));
        DeferredRepositoryFactory repositoryFactory = (DeferredRepositoryFactory)project.getObjects().newInstance(DeferredRepositoryFactory.class, new Object[]{project});
        repositoryFactory.groovy();
    }
}

