/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradleRuntimeCompatibility;
import dev.gradleplugins.internal.FinalizableComponent;
import dev.gradleplugins.internal.jvm.JvmCompatibilityProperties;
import dev.gradleplugins.internal.jvm.JvmCompatibilityPropertyFactory;
import javax.inject.Inject;
import org.gradle.api.Transformer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.util.GradleVersion;

abstract class DefaultGradlePluginDevelopmentCompatibilityExtension
implements GradlePluginDevelopmentCompatibilityExtension,
HasPublicType,
FinalizableComponent {
    private final JvmCompatibilityProperties compatibilities;
    private boolean finalized = false;

    @Inject
    public DefaultGradlePluginDevelopmentCompatibilityExtension(JavaPluginExtension java) {
        this.compatibilities = JvmCompatibilityPropertyFactory.of(java);
        this.getGradleApiVersion().convention(this.getMinimumGradleVersion().map(DefaultGradlePluginDevelopmentCompatibilityExtension.toLocalIfGradleSnapshotVersion()));
    }

    private static Transformer<String, String> toLocalIfGradleSnapshotVersion() {
        return it -> {
            if (GradleVersion.version((String)it).isSnapshot()) {
                return "local";
            }
            return it;
        };
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(GradlePluginDevelopmentCompatibilityExtension.class);
    }

    @Override
    public void finalizeComponent() {
        if (!this.finalized) {
            this.finalized = true;
            if (this.getMinimumGradleVersion().isPresent()) {
                this.compatibilities.set(GradleRuntimeCompatibility.minimumJavaVersionFor((String)this.getMinimumGradleVersion().get()));
            } else {
                this.getMinimumGradleVersion().set((Object)GradleVersion.current().getVersion());
            }
            this.getMinimumGradleVersion().disallowChanges();
            this.getGradleApiVersion().disallowChanges();
            this.compatibilities.finalizeValues();
        }
    }

    @Override
    public boolean isFinalized() {
        return this.finalized;
    }
}

