/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import dev.gradleplugins.CompositeGradlePluginTestingStrategy;
import dev.gradleplugins.GradlePluginTestingStrategy;
import dev.gradleplugins.GradlePluginTestingStrategyFactory;
import dev.gradleplugins.GradleVersionCoverageTestingStrategy;
import dev.gradleplugins.internal.GradlePluginTestingStrategyInternal;
import dev.gradleplugins.internal.ReleasedVersionDistributions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.provider.Provider;
import org.gradle.util.VersionNumber;

public final class GradlePluginTestingStrategyFactoryInternal
implements GradlePluginTestingStrategyFactory {
    private final ReleasedVersionDistributions releasedVersions;
    private final Provider<String> minimumVersion;

    public GradlePluginTestingStrategyFactoryInternal(Provider<String> minimumVersion) {
        this(minimumVersion, ReleasedVersionDistributions.GRADLE_DISTRIBUTIONS);
    }

    public GradlePluginTestingStrategyFactoryInternal(Provider<String> minimumVersion, ReleasedVersionDistributions releasedVersions) {
        this.minimumVersion = minimumVersion;
        this.releasedVersions = releasedVersions;
    }

    @Override
    public GradleVersionCoverageTestingStrategy getCoverageForMinimumVersion() {
        return new DefaultGradleVersionCoverageTestingStrategy("minimumGradle", () -> (String)this.minimumVersion.get(), () -> {
            String result = (String)this.minimumVersion.get();
            this.assertKnownMinimumVersion(result);
            return result;
        });
    }

    @Override
    public GradleVersionCoverageTestingStrategy getCoverageForLatestNightlyVersion() {
        return new DefaultGradleVersionCoverageTestingStrategy("latestNightly", () -> "latest-nightly", () -> this.releasedVersions.getMostRecentSnapshot().getVersion());
    }

    @Override
    public Provider<Set<GradleVersionCoverageTestingStrategy>> getCoverageForLatestGlobalAvailableVersionOfEachSupportedMajorVersions() {
        return this.minimumVersion.map(version -> {
            this.assertKnownMinimumVersion((String)version);
            int minimumMajorVersion = VersionNumber.parse((String)version).getMajor();
            Map<Integer, List<VersionNumber>> h = this.releasedVersions.getAllVersions().stream().filter(it -> !it.isSnapshot() && !it.getVersion().contains("-rc-")).map(it -> VersionNumber.parse((String)it.getVersion())).filter(it -> it.getMajor() >= minimumMajorVersion).collect(Collectors.groupingBy(it -> it.getMajor()));
            return h.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(it -> {
                it.sort(Comparator.reverseOrder());
                return this.coverageForGradleVersion(GradlePluginTestingStrategyFactoryInternal.format((VersionNumber)it.iterator().next()));
            }).collect(Collectors.toCollection(LinkedHashSet::new));
        });
    }

    private static String format(VersionNumber version) {
        StringBuilder builder = new StringBuilder();
        builder.append(version.getMajor()).append(".").append(version.getMinor());
        if (version.getMicro() > 0) {
            builder.append(".").append(version.getMicro());
        }
        return builder.toString();
    }

    @Override
    public GradleVersionCoverageTestingStrategy getCoverageForLatestGlobalAvailableVersion() {
        return new DefaultGradleVersionCoverageTestingStrategy("latestGlobalAvailable", () -> "latest-released", () -> this.releasedVersions.getMostRecentRelease().getVersion());
    }

    @Override
    public GradleVersionCoverageTestingStrategy coverageForGradleVersion(String version) {
        return new DefaultGradleVersionCoverageTestingStrategy(version, () -> version, () -> {
            if (!this.isKnownVersion(version)) {
                throw new IllegalArgumentException(String.format("Unknown Gradle version '%s' for adhoc testing strategy.", version));
            }
            return version;
        });
    }

    @Override
    public CompositeGradlePluginTestingStrategy composite(GradlePluginTestingStrategy firstStrategy, GradlePluginTestingStrategy secondStrategy, GradlePluginTestingStrategy ... otherStrategies) {
        List strategies = Stream.concat(Stream.of(firstStrategy, secondStrategy), Arrays.stream(otherStrategies)).peek(Objects::requireNonNull).peek(GradlePluginTestingStrategyFactoryInternal.assertNoCompositeStrategies()).peek(GradlePluginTestingStrategyFactoryInternal.assertNoDuplicatedStrategies()).peek(GradlePluginTestingStrategyFactoryInternal.assertNoDuplicatedStrategyTypes()).collect(Collectors.toList());
        return new DefaultCompositeGradlePluginTestingStrategy(strategies);
    }

    private static Consumer<GradlePluginTestingStrategy> assertNoCompositeStrategies() {
        return strategy -> {
            if (strategy instanceof CompositeGradlePluginTestingStrategy) {
                throw new IllegalArgumentException("Unable to compose testing strategy from composite testing strategies.");
            }
        };
    }

    private static Consumer<GradlePluginTestingStrategy> assertNoDuplicatedStrategies() {
        HashSet strategyHashes = new HashSet();
        return strategy -> {
            if (!strategyHashes.add(strategy)) {
                throw new IllegalArgumentException(String.format("Unable to compose testing strategy with multiple %s instances.", strategy.toString()));
            }
        };
    }

    private static Consumer<GradlePluginTestingStrategy> assertNoDuplicatedStrategyTypes() {
        HashSet strategyTypes = new HashSet();
        return strategy -> {
            if (!strategyTypes.add(strategy.getClass())) {
                throw new IllegalArgumentException(String.format("Unable to compose testing strategy with multiple %s type.", strategy.getClass().getSimpleName()));
            }
        };
    }

    private boolean isKnownVersion(String version) {
        return this.releasedVersions.getAllVersions().stream().anyMatch(it -> it.getVersion().equals(version));
    }

    private void assertKnownMinimumVersion(String version) {
        if (!this.isKnownVersion(version)) {
            throw new IllegalArgumentException(String.format("Unknown minimum Gradle version '%s' for testing strategy.", version));
        }
    }

    private static final class DefaultCompositeGradlePluginTestingStrategy
    implements CompositeGradlePluginTestingStrategy {
        private final Iterable<GradlePluginTestingStrategy> strategies;
        private final String name;

        private DefaultCompositeGradlePluginTestingStrategy(Iterable<GradlePluginTestingStrategy> strategies) {
            this.strategies = strategies;
            this.name = StringUtils.uncapitalize((String)StreamSupport.stream(strategies.spliterator(), false).map(it -> StringUtils.capitalize((String)it.getName())).collect(Collectors.joining()));
        }

        @Override
        public Iterator<GradlePluginTestingStrategy> iterator() {
            return this.strategies.iterator();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "strategy composed of <" + StreamSupport.stream(this.strategies.spliterator(), false).map(Object::toString).collect(Collectors.joining(", ")) + ">";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultCompositeGradlePluginTestingStrategy)) {
                return false;
            }
            DefaultCompositeGradlePluginTestingStrategy other = (DefaultCompositeGradlePluginTestingStrategy)o;
            Iterable<GradlePluginTestingStrategy> this$strategies = this.strategies;
            Iterable<GradlePluginTestingStrategy> other$strategies = other.strategies;
            return !(this$strategies == null ? other$strategies != null : !this$strategies.equals(other$strategies));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Iterable<GradlePluginTestingStrategy> $strategies = this.strategies;
            result = result * 59 + ($strategies == null ? 43 : $strategies.hashCode());
            return result;
        }
    }

    private final class DefaultGradleVersionCoverageTestingStrategy
    implements GradlePluginTestingStrategyInternal,
    GradleVersionCoverageTestingStrategy {
        private final String name;
        private final Supplier<String> rawVersionSupplier;
        private final Supplier<String> versionSupplier;

        DefaultGradleVersionCoverageTestingStrategy(String name, Supplier<String> rawVersionSupplier, Supplier<String> versionSupplier) {
            this.name = name;
            this.rawVersionSupplier = rawVersionSupplier;
            this.versionSupplier = versionSupplier;
        }

        @Override
        public boolean isLatestGlobalAvailable() {
            return GradlePluginTestingStrategyFactoryInternal.this.releasedVersions.getMostRecentRelease().getVersion().equals(this.getVersion());
        }

        @Override
        public boolean isLatestNightly() {
            return this.getVersion().contains("-") && GradlePluginTestingStrategyFactoryInternal.this.releasedVersions.getMostRecentSnapshot().getVersion().equals(this.getVersion());
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.versionSupplier.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultGradleVersionCoverageTestingStrategy)) {
                return false;
            }
            DefaultGradleVersionCoverageTestingStrategy that = (DefaultGradleVersionCoverageTestingStrategy)o;
            return Objects.equals(this.rawVersionSupplier.get(), that.rawVersionSupplier.get());
        }

        public int hashCode() {
            return Objects.hash(this.rawVersionSupplier.get(), this.getName());
        }

        public String toString() {
            return "coverage for Gradle v" + this.getVersion();
        }
    }
}

