/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class ReleasedVersionDistributions {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GradleRelease getMostRecentSnapshot() {
        try (InputStreamReader reader = new InputStreamReader(new URL("https://services.gradle.org/versions/nightly").openConnection().getInputStream());){
            GradleRelease gradleRelease = (GradleRelease)new Gson().fromJson((Reader)reader, GradleRelease.class);
            return gradleRelease;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the last snapshot version", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GradleRelease getMostRecentRelease() {
        try (InputStreamReader reader = new InputStreamReader(new URL("https://services.gradle.org/versions/current").openConnection().getInputStream());){
            GradleRelease gradleRelease = (GradleRelease)new Gson().fromJson((Reader)reader, GradleRelease.class);
            return gradleRelease;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the last version", e);
        }
    }

    public static final class GradleRelease {
        private final String version;
        private final boolean snapshot;
        private final boolean current;
        private final String rcFor;

        public GradleRelease(String version, boolean snapshot, boolean current, String rcFor) {
            this.version = version;
            this.snapshot = snapshot;
            this.current = current;
            this.rcFor = rcFor;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isSnapshot() {
            return this.snapshot;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public String getRcFor() {
            return this.rcFor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleRelease)) {
                return false;
            }
            GradleRelease other = (GradleRelease)o;
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            if (this.isSnapshot() != other.isSnapshot()) {
                return false;
            }
            if (this.isCurrent() != other.isCurrent()) {
                return false;
            }
            String this$rcFor = this.getRcFor();
            String other$rcFor = other.getRcFor();
            return !(this$rcFor == null ? other$rcFor != null : !this$rcFor.equals(other$rcFor));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            result = result * 59 + (this.isSnapshot() ? 79 : 97);
            result = result * 59 + (this.isCurrent() ? 79 : 97);
            String $rcFor = this.getRcFor();
            result = result * 59 + ($rcFor == null ? 43 : $rcFor.hashCode());
            return result;
        }

        public String toString() {
            return "ReleasedVersionDistributions.GradleRelease(version=" + this.getVersion() + ", snapshot=" + this.isSnapshot() + ", current=" + this.isCurrent() + ", rcFor=" + this.getRcFor() + ")";
        }
    }
}

