/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal;

import java.util.function.Consumer;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenRepositoryContentDescriptor;

public abstract class DeferredRepositoryFactory {
    private final Project project;

    @Inject
    public DeferredRepositoryFactory(Project project) {
        this.project = project;
    }

    public void groovy() {
        this.project.afterEvaluate(DeferredRepositoryFactory::createGroovyRepository);
    }

    public void spock() {
        this.project.afterEvaluate(DeferredRepositoryFactory::createSpockRepository);
    }

    private static void createGroovyRepository(Project project) {
        project.getRepositories().mavenCentral(repo -> {
            repo.setName("Gradle Plugin Development - Groovy");
            repo.mavenContent(content -> DeferredRepositoryFactory.allowGroovy().accept((MavenRepositoryContentDescriptor)content));
        });
    }

    private static void createSpockRepository(Project project) {
        project.getRepositories().mavenCentral(repository -> {
            repository.setName("Gradle Plugin Development - Spock Framework");
            repository.mavenContent(content -> DeferredRepositoryFactory.allowSpock().andThen(DeferredRepositoryFactory.allowGroovy()).accept((MavenRepositoryContentDescriptor)content));
        });
    }

    public static Consumer<MavenRepositoryContentDescriptor> allowSpock() {
        return content -> {
            content.includeModule("org.spockframework", "spock-bom");
            content.includeModule("org.spockframework", "spock-core");
            content.includeModule("junit", "junit");
            content.includeModule("org.hamcrest", "hamcrest-core");
            content.includeModule("org.hamcrest", "hamcrest-parent");
        };
    }

    private static Consumer<MavenRepositoryContentDescriptor> allowGroovy() {
        return content -> {
            content.includeGroup("org.codehaus.groovy");
            content.includeModule("junit", "junit");
            content.includeModule("org.hamcrest", "hamcrest-core");
            content.includeModule("jline", "jline");
            content.includeModule("com.thoughtworks.qdox", "qdox");
            content.includeModule("commons-cli", "commons-cli");
            content.includeModule("info.picocli", "picocli");
            content.includeModule("org.apache.ant", "ant");
            content.includeModule("org.apache.ant", "ant-parent");
            content.includeModule("org.apache.ant", "ant-antlr");
            content.includeModule("org.apache.ant", "ant-junit");
            content.includeModule("org.apache.ant", "ant-launcher");
            content.includeModule("org.apache.commons", "commons-parent");
            content.includeModule("org.codehaus", "codehaus-parent");
            content.includeModule("org.sonatype.oss", "oss-parent");
            content.includeModule("org.hamcrest", "hamcrest-parent");
            content.includeModule("org.apache", "apache");
            content.includeModule("org.apiguardian", "apiguardian-api");
            content.includeModule("org.junit.platform", "junit-platform-launcher");
            content.includeModule("org.junit.platform", "junit-platform-engine");
            content.includeModule("org.opentest4j", "opentest4j");
            content.includeModule("org.junit.platform", "junit-platform-commons");
            content.includeModule("org.testng", "testng");
            content.includeModule("com.beust", "jcommander");
            content.includeModule("org.junit.jupiter", "junit-jupiter-api");
            content.includeModule("org.junit.jupiter", "junit-jupiter-engine");
        };
    }
}

