/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.internal.plugins;

import dev.gradleplugins.GradlePluginDevelopmentCompatibilityExtension;
import dev.gradleplugins.GradleRuntimeCompatibility;
import dev.gradleplugins.internal.GradlePluginDevelopmentDependencyExtensionInternal;
import dev.gradleplugins.internal.GradlePluginDevelopmentExtensionInternal;
import dev.gradleplugins.internal.GradlePluginDevelopmentRepositoryExtensionInternal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.artifacts.dependencies.SelfResolvingDependencyInternal;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.util.VersionNumber;

public abstract class AbstractGradlePluginDevelopmentPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        AbstractGradlePluginDevelopmentPlugin.assertOtherGradlePluginDevelopmentPluginsAreNeverApplied(project.getPluginManager(), this.getPluginId());
        AbstractGradlePluginDevelopmentPlugin.assertJavaGradlePluginIsNotPreviouslyApplied(project.getPluginManager(), this.getPluginId());
        AbstractGradlePluginDevelopmentPlugin.assertKotlinDslPluginIsNeverApplied(project.getPluginManager(), this.getPluginId());
        this.doApply(project);
    }

    protected abstract void doApply(Project var1);

    protected abstract String getPluginId();

    public static void assertOtherGradlePluginDevelopmentPluginsAreNeverApplied(PluginManager pluginManager, String currentPluginId) {
        AbstractGradlePluginDevelopmentPlugin.getOtherGradlePluginDevelopmentPlugins(currentPluginId).stream().filter(arg_0 -> ((PluginManager)pluginManager).hasPlugin(arg_0)).findAny().ifPresent(id -> {
            throw new GradleException("The '" + currentPluginId + "' cannot be applied with '" + id + "', please apply just one of them.");
        });
    }

    private static List<String> getOtherGradlePluginDevelopmentPlugins(String pluginId) {
        return Stream.of("dev.gradleplugins.java-gradle-plugin", "dev.gradleplugins.groovy-gradle-plugin", "dev.gradleplugins.kotlin-gradle-plugin").filter(it -> !it.equals(pluginId)).collect(Collectors.toList());
    }

    public static void assertJavaGradlePluginIsNotPreviouslyApplied(PluginManager pluginManager, String currentPluginId) {
        if (pluginManager.hasPlugin("java-gradle-plugin") && !pluginManager.hasPlugin("org.gradle.kotlin.kotlin-dsl")) {
            throw new GradleException("The Gradle core plugin 'java-gradle-plugin' should not be applied within your build when using '" + currentPluginId + "'.");
        }
    }

    public static void assertKotlinDslPluginIsNeverApplied(PluginManager pluginManager, String currentPluginId) {
        pluginManager.withPlugin("org.gradle.kotlin.kotlin-dsl", appliedPlugin -> {
            throw new GradleException("The Gradle plugin 'kotlin-dsl' should not be applied within your build when using '" + currentPluginId + "'.");
        });
    }

    public static void configureDefaultJavaCompatibility(JavaPluginExtension java, VersionNumber minimumGradleVersion) {
        JavaVersion minimumJavaVersion = GradleRuntimeCompatibility.minimumJavaVersionFor(minimumGradleVersion);
        if (java.getSourceCompatibility().equals((Object)JavaVersion.VERSION_1_1)) {
            java.setSourceCompatibility(minimumJavaVersion);
        }
        if (java.getTargetCompatibility().equals((Object)JavaVersion.VERSION_1_1)) {
            java.setTargetCompatibility(minimumJavaVersion);
        }
    }

    public static GradlePluginDevelopmentCompatibilityExtension registerCompatibilityExtension(Project project) {
        GradlePluginDevelopmentExtension gradlePlugin = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        GradlePluginDevelopmentCompatibilityExtension extension = (GradlePluginDevelopmentCompatibilityExtension)project.getObjects().newInstance(GradlePluginDevelopmentCompatibilityExtension.class, new Object[0]);
        AbstractGradlePluginDevelopmentPlugin.configureExtension(extension, project);
        ((ExtensionAware)gradlePlugin).getExtensions().add("compatibility", (Object)extension);
        return extension;
    }

    public static <T> GradlePluginDevelopmentExtensionInternal registerLanguageExtension(Project project, String languageName, Class<T> type) {
        GradlePluginDevelopmentExtension gradlePlugin = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        GradlePluginDevelopmentExtensionInternal extension = (GradlePluginDevelopmentExtensionInternal)project.getObjects().newInstance(GradlePluginDevelopmentExtensionInternal.class, new Object[]{project.getExtensions().getByType(JavaPluginExtension.class)});
        ((ExtensionAware)gradlePlugin).getExtensions().add(type, languageName, type.cast(extension));
        return extension;
    }

    public static void removeGradleApiProjectDependency(Project project) {
        project.getConfigurations().getByName("api").getDependencies().removeIf(it -> {
            if (it instanceof SelfResolvingDependencyInternal) {
                return ((SelfResolvingDependencyInternal)it).getTargetComponentId().getDisplayName().equals("Gradle API");
            }
            return false;
        });
    }

    public static void configureExtension(GradlePluginDevelopmentCompatibilityExtension extension, Project project) {
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaVersion defaultSourceCompatibility = java.getSourceCompatibility();
        JavaVersion defaultTargetCompatibility = java.getTargetCompatibility();
        java.setSourceCompatibility(JavaVersion.VERSION_1_1);
        java.setTargetCompatibility(JavaVersion.VERSION_1_1);
        project.afterEvaluate(proj -> {
            if (extension.getMinimumGradleVersion().isPresent()) {
                AbstractGradlePluginDevelopmentPlugin.configureDefaultJavaCompatibility(java, VersionNumber.parse((String)((String)extension.getMinimumGradleVersion().get())));
            } else {
                extension.getMinimumGradleVersion().set((Object)project.getGradle().getGradleVersion());
                if (java.getSourceCompatibility().equals((Object)JavaVersion.VERSION_1_1)) {
                    java.setSourceCompatibility(defaultSourceCompatibility);
                }
                if (java.getTargetCompatibility().equals((Object)JavaVersion.VERSION_1_1)) {
                    java.setTargetCompatibility(defaultTargetCompatibility);
                }
            }
            extension.getMinimumGradleVersion().disallowChanges();
        });
        GradlePluginDevelopmentDependencyExtensionInternal dependencies = GradlePluginDevelopmentDependencyExtensionInternal.of(project.getDependencies());
        dependencies.add("compileOnly", (Provider<Object>)extension.getMinimumGradleVersion().map(dependencies::gradleApi));
        GradlePluginDevelopmentRepositoryExtensionInternal.of(project.getRepositories()).gradlePluginDevelopment();
    }
}

